/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SdkModificator {
    @NotNull
    public String getName();

    public void setName(@NotNull String var1);

    public String getHomePath();

    public void setHomePath(String var1);

    @Nullable
    public String getVersionString();

    public void setVersionString(String var1);

    public SdkAdditionalData getSdkAdditionalData();

    public void setSdkAdditionalData(SdkAdditionalData var1);

    public VirtualFile @NotNull [] getRoots(@NotNull OrderRootType var1);

    default public String @NotNull [] getUrls(@NotNull OrderRootType rootType) {
        return (String[])ContainerUtil.map((Object[])this.getRoots(rootType), file -> file.getUrl(), (Object[])ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void addRoot(@NotNull VirtualFile var1, @NotNull OrderRootType var2);

    default public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        VirtualFile rootFile = VirtualFileManager.getInstance().findFileByUrl(url);
        if (rootFile != null) {
            this.addRoot(rootFile, rootType);
        }
    }

    public void removeRoot(@NotNull VirtualFile var1, @NotNull OrderRootType var2);

    default public void removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        for (VirtualFile file : this.getRoots(rootType)) {
            if (!file.getUrl().equals(url)) continue;
            this.removeRoot(file, rootType);
            break;
        }
    }

    public void removeRoots(@NotNull OrderRootType var1);

    public void removeAllRoots();

    public void commitChanges();

    public boolean isWritable();
}

