/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.EdtReplacementThread;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Task
implements TaskInfo,
Progressive {
    private static final Logger LOG = Logger.getInstance(Task.class);
    protected final Project myProject;
    protected String myTitle;
    private final boolean myCanBeCancelled;
    private String myCancelText = CoreBundle.message("button.cancel", new Object[0]);
    private String myCancelTooltipText = CoreBundle.message("button.cancel", new Object[0]);

    private Task(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title, boolean canBeCancelled) {
        this.myProject = project;
        this.myTitle = title;
        this.myCanBeCancelled = canBeCancelled;
    }

    public void onCancel() {
    }

    public void onSuccess() {
    }

    @Deprecated
    public void onError(@NotNull Exception error) {
        LOG.error((Throwable)error);
    }

    public void onThrowable(@NotNull Throwable error) {
        if (error instanceof Exception) {
            this.onError((Exception)error);
        } else {
            LOG.error(error);
        }
    }

    public void onFinished() {
    }

    @NotNull
    public EdtReplacementThread whereToRunCallbacks() {
        return EdtReplacementThread.EDT_WITH_IW;
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final void queue() {
        ProgressManager.getInstance().run(this);
    }

    @Override
    @NotNull
    public final String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public final Task setTitle(@Nls @NlsContexts.ProgressTitle @NotNull String title) {
        this.myTitle = title;
        return this;
    }

    @Override
    public final String getCancelText() {
        return this.myCancelText;
    }

    @NotNull
    public final Task setCancelText(@NlsContexts.Button String cancelText) {
        this.myCancelText = cancelText;
        return this;
    }

    @Nullable
    public NotificationInfo getNotificationInfo() {
        return null;
    }

    @Nullable
    public NotificationInfo notifyFinished() {
        return this.getNotificationInfo();
    }

    public boolean isHeadless() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    @NotNull
    public final Task setCancelTooltipText(@NlsContexts.Tooltip String cancelTooltipText) {
        this.myCancelTooltipText = cancelTooltipText;
        return this;
    }

    @Override
    public final String getCancelTooltipText() {
        return this.myCancelTooltipText;
    }

    @Override
    public final boolean isCancellable() {
        return this.myCanBeCancelled;
    }

    public abstract boolean isModal();

    @NotNull
    public final Modal asModal() {
        if (this.isModal()) {
            return (Modal)this;
        }
        throw new IllegalStateException("Not a modal task");
    }

    @NotNull
    public final Backgroundable asBackgroundable() {
        if (!this.isModal()) {
            return (Backgroundable)this;
        }
        throw new IllegalStateException("Not a backgroundable task");
    }

    public static abstract class WithResult<T, E extends Exception>
    extends Modal {
        private final Ref<T> myResult = Ref.create();
        private final Ref<Throwable> myError = Ref.create();

        public WithResult(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title, boolean canBeCancelled) {
            super(project, title, canBeCancelled);
        }

        @Override
        public final void run(@NotNull ProgressIndicator indicator) {
            try {
                this.myResult.set(this.compute(indicator));
            }
            catch (Throwable t) {
                this.myError.set((Object)t);
            }
        }

        protected abstract T compute(@NotNull ProgressIndicator var1) throws E;

        public T getResult() throws E {
            Throwable t = (Throwable)this.myError.get();
            ExceptionUtil.rethrowUnchecked((Throwable)t);
            if (t != null) {
                throw (Exception)t;
            }
            return (T)this.myResult.get();
        }
    }

    public static class NotificationInfo {
        private final String myNotificationName;
        private final String myNotificationTitle;
        private final String myNotificationText;
        private final boolean myShowWhenFocused;

        public NotificationInfo(@NotNull String notificationName, @NotNull @NlsContexts.SystemNotificationTitle String notificationTitle, @NotNull @NlsContexts.SystemNotificationText String notificationText) {
            this(notificationName, notificationTitle, notificationText, false);
        }

        public NotificationInfo(@NotNull String notificationName, @NotNull @NlsContexts.SystemNotificationTitle String notificationTitle, @NotNull @NlsContexts.SystemNotificationText String notificationText, boolean showWhenFocused) {
            this.myNotificationName = notificationName;
            this.myNotificationTitle = notificationTitle;
            this.myNotificationText = notificationText;
            this.myShowWhenFocused = showWhenFocused;
        }

        @NotNull
        public String getNotificationName() {
            return this.myNotificationName;
        }

        @NotNull
        public @NlsContexts.SystemNotificationTitle String getNotificationTitle() {
            return this.myNotificationTitle;
        }

        @NotNull
        public @NlsContexts.SystemNotificationText String getNotificationText() {
            return this.myNotificationText;
        }

        public boolean isShowWhenFocused() {
            return this.myShowWhenFocused;
        }
    }

    public static abstract class ConditionalModal
    extends Backgroundable {
        public ConditionalModal(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title, boolean canBeCancelled, @NotNull PerformInBackgroundOption backgroundOption) {
            super(project, title, canBeCancelled, backgroundOption);
        }

        @Override
        public final boolean isConditionalModal() {
            return true;
        }
    }

    public static abstract class Modal
    extends Task {
        public Modal(@Nullable Project project, @NlsContexts.DialogTitle @NotNull String title, boolean canBeCancelled) {
            super(project, title, canBeCancelled);
        }

        @Override
        public final boolean isModal() {
            return true;
        }
    }

    public static abstract class Backgroundable
    extends Task
    implements PerformInBackgroundOption {
        protected final PerformInBackgroundOption myBackgroundOption;

        public Backgroundable(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title) {
            this(project, title, true);
        }

        public Backgroundable(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title, boolean canBeCancelled) {
            this(project, title, canBeCancelled, (PerformInBackgroundOption)null);
        }

        public Backgroundable(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title, boolean canBeCancelled, @Nullable PerformInBackgroundOption backgroundOption) {
            super(project, title, canBeCancelled);
            this.myBackgroundOption = backgroundOption;
            if (StringUtil.isEmptyOrSpaces((String)title)) {
                LOG.warn("Empty title for backgroundable task.", new Throwable());
            }
        }

        @Override
        public boolean shouldStartInBackground() {
            return this.myBackgroundOption == null || this.myBackgroundOption.shouldStartInBackground();
        }

        @Override
        public void processSentToBackground() {
            if (this.myBackgroundOption != null) {
                this.myBackgroundOption.processSentToBackground();
            }
        }

        @Override
        public final boolean isModal() {
            return false;
        }

        public boolean isConditionalModal() {
            return false;
        }
    }
}

