/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableConstantFunction;
import com.intellij.util.NullableFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathReference {
    public static final NullableFunction<PathReference, Icon> NULL_ICON = new NullableConstantFunction(null);
    private final String myPath;
    private final NullableLazyValue<Icon> myIcon;

    public PathReference(@NotNull String path2, final @NotNull Function<? super PathReference, ? extends Icon> icon) {
        this.myPath = path2;
        this.myIcon = new NullableLazyValue<Icon>(){

            protected Icon compute() {
                return (Icon)icon.fun((Object)PathReference.this);
            }
        };
    }

    @NotNull
    public String getPath() {
        return this.myPath;
    }

    @NotNull
    public String getTrimmedPath() {
        return PathReference.trimPath(this.myPath);
    }

    @Nullable
    public Icon getIcon() {
        return (Icon)this.myIcon.getValue();
    }

    @Nullable
    public PsiElement resolve() {
        return null;
    }

    public static String trimPath(String url) {
        for (int i = 0; i < url.length(); ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '?': {
                    return url.substring(0, i);
                }
            }
        }
        return url;
    }

    public static class ResolveFunction
    implements NullableFunction<PathReference, Icon> {
        public static final ResolveFunction NULL_RESOLVE_FUNCTION = new ResolveFunction(null);
        private final Icon myDefaultIcon;

        public ResolveFunction(@Nullable Icon defaultValue) {
            this.myDefaultIcon = defaultValue;
        }

        public Icon fun(PathReference pathReference) {
            PsiElement element = pathReference.resolve();
            return element == null ? this.myDefaultIcon : element.getIcon(2);
        }
    }
}

