/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.colors;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.options.colors.AbstractKeyDescriptor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ColorDescriptor
extends AbstractKeyDescriptor<ColorKey> {
    public static final ColorDescriptor[] EMPTY_ARRAY = new ColorDescriptor[0];
    private final Kind myKind;

    public ColorDescriptor(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String displayName, @NotNull ColorKey key, @NotNull Kind kind) {
        super(displayName, key);
        this.myKind = kind;
    }

    @NotNull
    public Kind getKind() {
        return this.myKind;
    }

    @Override
    @NotNull
    public ColorKey getKey() {
        return (ColorKey)super.getKey();
    }

    public static enum Kind {
        BACKGROUND,
        FOREGROUND,
        BACKGROUND_WITH_TRANSPARENCY,
        FOREGROUND_WITH_TRANSPARENCY;


        public boolean isBackground() {
            return this == BACKGROUND || this == BACKGROUND_WITH_TRANSPARENCY;
        }

        public boolean isForeground() {
            return this == FOREGROUND || this == FOREGROUND_WITH_TRANSPARENCY;
        }

        public boolean isWithTransparency() {
            return this == FOREGROUND_WITH_TRANSPARENCY || this == BACKGROUND_WITH_TRANSPARENCY;
        }
    }
}

