/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionInstantiationException;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.ConfigurableTreeRenderer;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="configurable")
public class ConfigurableEP<T extends UnnamedConfigurable>
implements PluginAware {
    private static final Logger LOG = Logger.getInstance(ConfigurableEP.class);
    private PluginDescriptor pluginDescriptor;
    @Attribute(value="displayName")
    @Nls(capitalization=Nls.Capitalization.Title)
    public String displayName;
    @Attribute(value="key")
    @Nls(capitalization=Nls.Capitalization.Title)
    public String key;
    @Attribute(value="bundle")
    public String bundle;
    @Property(surroundWithTag=false)
    @XCollection
    public List<ConfigurableEP<?>> children;
    @Attribute(value="childrenEPName")
    public String childrenEPName;
    @Attribute(value="dynamic")
    public boolean dynamic;
    @Attribute(value="parentId")
    public String parentId;
    @Attribute(value="id")
    public String id;
    @Attribute(value="groupId")
    public String groupId;
    @Attribute(value="groupWeight")
    public int groupWeight;
    @Attribute(value="nonDefaultProject")
    public boolean nonDefaultProject;
    @Deprecated
    @Attribute(value="implementation")
    public String implementationClass;
    @Attribute(value="instance")
    public String instanceClass;
    @Attribute(value="provider")
    public String providerClass;
    @Attribute(value="treeRenderer")
    public String treeRendererClass;
    private final AtomicNotNullLazyValue<ObjectProducer> myProducer = AtomicNotNullLazyValue.createValue(this::createProducer);
    private ComponentManager componentManager;
    private Project myProject;

    @Transient
    @NotNull
    public final PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public final void setPluginDescriptor(@NotNull PluginDescriptor value) {
        this.pluginDescriptor = value;
    }

    @NotNull
    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        ResourceBundle resourceBundle = this.findBundle();
        if (resourceBundle == null || this.key == null) {
            if (this.key == null) {
                LOG.warn("Bundle key missed for " + this.displayName);
            } else {
                LOG.warn("Bundle missed for " + this.displayName);
            }
            if (this.providerClass == null) {
                return this.instanceClass == null ? this.implementationClass : this.instanceClass;
            }
            return this.providerClass;
        }
        return AbstractBundle.message((ResourceBundle)resourceBundle, (String)this.key, (Object[])new Object[0]);
    }

    @Nullable
    public ResourceBundle findBundle() {
        String pathToBundle = this.findPathToBundle();
        if (pathToBundle == null) {
            return null;
        }
        ClassLoader loader = this.pluginDescriptor == null ? null : this.pluginDescriptor.getPluginClassLoader();
        return DynamicBundle.INSTANCE.getResourceBundle(pathToBundle, loader != null ? loader : this.getClass().getClassLoader());
    }

    @Nullable
    private String findPathToBundle() {
        if (this.bundle == null && this.pluginDescriptor != null) {
            return this.pluginDescriptor.getResourceBundleBaseName();
        }
        return this.bundle;
    }

    @NotNull
    public List<ConfigurableEP<?>> getChildren() {
        for (ConfigurableEP<?> child : this.children) {
            child.componentManager = this.componentManager;
            child.pluginDescriptor = this.pluginDescriptor;
            child.myProject = this.myProject;
        }
        return this.children;
    }

    public boolean isAvailable() {
        return !this.nonDefaultProject || this.myProject == null || !this.myProject.isDefault();
    }

    public ConfigurableEP() {
        this(ApplicationManager.getApplication());
    }

    protected ConfigurableEP(@NotNull ComponentManager componentManager) {
        this.myProject = componentManager instanceof Project ? (Project)componentManager : null;
        this.componentManager = componentManager;
    }

    @NonInjectable
    public ConfigurableEP(@NotNull Project project) {
        this.myProject = project;
        this.componentManager = project;
    }

    @NotNull
    protected ObjectProducer createProducer() {
        try {
            if (this.providerClass != null) {
                return new ProviderProducer(this.instantiateConfigurableProvider());
            }
            if (this.instanceClass != null) {
                return new ClassProducer(this.componentManager, this.instanceClass, this.pluginDescriptor);
            }
            if (this.implementationClass != null) {
                return new ClassProducer(this.componentManager, this.implementationClass, this.pluginDescriptor);
            }
            throw new PluginException("configurable class name is not set", this.pluginDescriptor == null ? null : this.pluginDescriptor.getPluginId());
        }
        catch (AssertionError | Exception | LinkageError error) {
            LOG.error((Throwable)new PluginException((Throwable)error, this.pluginDescriptor == null ? null : this.pluginDescriptor.getPluginId()));
            return new ObjectProducer();
        }
    }

    @Nullable
    public final ConfigurableProvider instantiateConfigurableProvider() {
        return this.providerClass != null ? (ConfigurableProvider)this.componentManager.instantiateExtensionWithPicoContainerOnlyIfNeeded(this.providerClass, this.pluginDescriptor) : null;
    }

    @Nullable
    public final Class<?> findClassOrNull(@NotNull String className) {
        try {
            ClassLoader classLoader = this.pluginDescriptor == null ? null : this.pluginDescriptor.getPluginClassLoader();
            return Class.forName(className, true, classLoader);
        }
        catch (Throwable t) {
            LOG.error((Throwable)new ExtensionInstantiationException(t, this.pluginDescriptor));
            return null;
        }
    }

    @Nullable
    public T createConfigurable() {
        ObjectProducer producer = (ObjectProducer)this.myProducer.getValue();
        if (producer.canCreateElement()) {
            UnnamedConfigurable configurable = (UnnamedConfigurable)producer.createElement();
            return (T)configurable;
        }
        return null;
    }

    @Nullable
    public ConfigurableTreeRenderer createTreeRenderer() {
        if (this.treeRendererClass == null) {
            return null;
        }
        try {
            return (ConfigurableTreeRenderer)this.componentManager.instantiateExtensionWithPicoContainerOnlyIfNeeded(this.treeRendererClass, this.pluginDescriptor);
        }
        catch (ProcessCanceledException exception) {
            throw exception;
        }
        catch (AssertionError | Exception | LinkageError e) {
            LOG.error((Throwable)new PluginException((Throwable)e, this.pluginDescriptor == null ? null : this.pluginDescriptor.getPluginId()));
            return null;
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean canCreateConfigurable() {
        return ((ObjectProducer)this.myProducer.getValue()).canCreateElement();
    }

    @Nullable
    public Class<?> getConfigurableType() {
        return ((ObjectProducer)this.myProducer.getValue()).getType();
    }

    private static final class ClassProducer
    extends ObjectProducer {
        private final ComponentManager componentManager;
        private final String className;
        private final PluginDescriptor pluginDescriptor;

        private ClassProducer(@NotNull ComponentManager componentManager, @NotNull String className, @Nullable PluginDescriptor pluginDescriptor) {
            this.componentManager = componentManager;
            this.className = className;
            this.pluginDescriptor = pluginDescriptor;
        }

        @Override
        protected Object createElement() {
            try {
                return this.componentManager.instantiateExtensionWithPicoContainerOnlyIfNeeded(this.className, this.pluginDescriptor);
            }
            catch (ProcessCanceledException exception) {
                throw exception;
            }
            catch (ExtensionNotApplicableException ignore) {
                return null;
            }
            catch (AssertionError | Exception | LinkageError e) {
                LOG.error("Cannot create configurable", (Throwable)e);
                return null;
            }
        }

        @Override
        protected boolean canCreateElement() {
            return true;
        }

        @Override
        protected Class<?> getType() {
            return null;
        }
    }

    private static final class ProviderProducer
    extends ObjectProducer {
        private final ConfigurableProvider myProvider;

        private ProviderProducer(ConfigurableProvider provider) {
            this.myProvider = provider;
        }

        @Override
        protected Object createElement() {
            return this.myProvider == null ? null : this.myProvider.createConfigurable();
        }

        @Override
        protected boolean canCreateElement() {
            return this.myProvider != null && this.myProvider.canCreateConfigurable();
        }
    }

    protected static class ObjectProducer {
        protected ObjectProducer() {
        }

        protected Object createElement() {
            return null;
        }

        protected boolean canCreateElement() {
            return false;
        }

        protected Class<?> getType() {
            return null;
        }
    }
}

