/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurableBase<UI extends ConfigurableUi<S>, S>
implements SearchableConfigurable,
Configurable.NoScroll {
    private final String id;
    private final String displayName;
    private final String helpTopic;
    private UI ui;

    protected ConfigurableBase(@NonNls @NotNull String id, @Nls @NotNull String displayName, @NonNls @Nullable String helpTopic) {
        this.id = id;
        this.displayName = displayName;
        this.helpTopic = helpTopic;
    }

    @Override
    @NotNull
    public final String getId() {
        return this.id;
    }

    @Override
    @Nls
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Nullable
    public final String getHelpTopic() {
        return this.helpTopic;
    }

    @NotNull
    protected abstract S getSettings();

    @Override
    public void reset() {
        if (this.ui != null) {
            this.ui.reset(this.getSettings());
        }
    }

    @Override
    @NotNull
    public final JComponent createComponent() {
        if (this.ui == null) {
            this.ui = this.createUi();
        }
        return this.ui.getComponent();
    }

    @Override
    @Nullable
    public Runnable enableSearch(String option) {
        return this.ui == null ? null : this.ui.enableSearch(option);
    }

    protected abstract UI createUi();

    @Override
    public final boolean isModified() {
        return this.ui != null && this.ui.isModified(this.getSettings());
    }

    @Override
    public final void apply() throws ConfigurationException {
        if (this.ui != null) {
            this.ui.apply(this.getSettings());
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.ui != null ? this.ui.getPreferredFocusedComponent() : null;
    }

    @Override
    public void disposeUIResources() {
        UI ui = this.ui;
        if (ui != null) {
            this.ui = null;
            if (ui instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)ui));
            }
        }
    }
}

