/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.ide.ui.UINumericRange;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Configurable
extends UnnamedConfigurable {
    public static final ExtensionPointName<ConfigurableEP<Configurable>> APPLICATION_CONFIGURABLE = new ExtensionPointName("com.intellij.applicationConfigurable");
    public static final ProjectExtensionPointName<ConfigurableEP<Configurable>> PROJECT_CONFIGURABLE = new ProjectExtensionPointName("com.intellij.projectConfigurable");

    @Contract(pure=true)
    public @NlsContexts.ConfigurableName String getDisplayName();

    @Nullable
    @NonNls
    @Contract(pure=true)
    default public String getHelpTopic() {
        return null;
    }

    default public boolean isModified(@NotNull JTextField textField, @NotNull String value) {
        return !StringUtil.equals((CharSequence)textField.getText().trim(), (CharSequence)value);
    }

    default public boolean isModified(@NotNull JTextField textField, int value, @NotNull UINumericRange range) {
        try {
            int currentValue = Integer.parseInt(textField.getText().trim());
            return range.fit(currentValue) == currentValue && currentValue != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    default public boolean isModified(@NotNull JToggleButton toggleButton, boolean value) {
        return toggleButton.isSelected() != value;
    }

    default public <T> boolean isModified(@NotNull ComboBox<T> comboBox, T value) {
        return !Comparing.equal((Object)comboBox.getSelectedItem(), value);
    }

    default public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public static interface TopComponentProvider {
        default public boolean isAvailable() {
            return true;
        }

        @NotNull
        public Component getCenterComponent(@NotNull TopComponentController var1);
    }

    public static interface TopComponentController {
        public static final TopComponentController EMPTY = new TopComponentController(){

            @Override
            public void setLeftComponent(@Nullable Component component) {
            }

            @Override
            public void showProgress(boolean start) {
            }
        };

        public void setLeftComponent(@Nullable Component var1);

        public void showProgress(boolean var1);
    }

    public static interface WithEpDependencies {
        @NotNull
        public Collection<BaseExtensionPointName<?>> getDependencies();
    }

    public static interface VariableProjectAppLevel {
        public boolean isProjectLevel();
    }

    public static interface NoMargin {
    }

    public static interface NoScroll {
    }

    @FunctionalInterface
    public static interface Composite {
        public Configurable @NotNull [] getConfigurables();
    }
}

