/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.PathUtilRt;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleUtilCore {
    public static final Key<Module> KEY_MODULE = new Key("Module");

    public static boolean projectContainsFile(@NotNull Project project, @NotNull VirtualFile file, boolean isLibraryElement) {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        if (isLibraryElement) {
            List<OrderEntry> orders = projectFileIndex.getOrderEntriesForFile(file);
            for (OrderEntry orderEntry : orders) {
                if (!(orderEntry instanceof JdkOrderEntry) && !(orderEntry instanceof LibraryOrderEntry)) continue;
                return true;
            }
            return false;
        }
        return projectFileIndex.isInContent(file);
    }

    @NotNull
    public static String getModuleNameInReadAction(@NotNull Module module) {
        return (String)ReadAction.compute(module::getName);
    }

    public static boolean isModuleDisposed(@NotNull PsiElement element) {
        Module module;
        if (!element.isValid()) {
            return true;
        }
        Project project = element.getProject();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return true;
        }
        VirtualFile vFile = file.getVirtualFile();
        Module module2 = module = vFile == null ? null : projectFileIndex.getModuleForFile(vFile);
        return module == null ? !projectFileIndex.isInLibraryClasses(vFile) : module.isDisposed();
    }

    @Nullable
    public static Module findModuleForFile(@Nullable PsiFile containingFile) {
        VirtualFile vFile;
        if (containingFile != null && (vFile = containingFile.getVirtualFile()) != null) {
            return ModuleUtilCore.findModuleForFile(vFile, containingFile.getProject());
        }
        return null;
    }

    @Nullable
    public static Module findModuleForFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (project.isDefault()) {
            return null;
        }
        return ProjectFileIndex.getInstance(project).getModuleForFile(file);
    }

    @Nullable
    public static Module findModuleForPsiElement(@NotNull PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null ? !element.isValid() : !containingFile.isValid()) {
            return null;
        }
        Project project = (containingFile == null ? element : containingFile).getProject();
        if (project.isDefault()) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        if (element instanceof PsiFileSystemItem && (!(element instanceof PsiFile) || element.getContext() == null)) {
            VirtualFile vFile = ((PsiFileSystemItem)element).getVirtualFile();
            if (vFile == null) {
                VirtualFile virtualFile2 = vFile = containingFile == null ? null : containingFile.getOriginalFile().getVirtualFile();
                if (vFile == null) {
                    return (Module)element.getUserData(KEY_MODULE);
                }
            }
            if (fileIndex.isInLibrary(vFile)) {
                List<OrderEntry> orderEntries = fileIndex.getOrderEntriesForFile(vFile);
                if (orderEntries.isEmpty()) {
                    return null;
                }
                if (orderEntries.size() == 1) {
                    return orderEntries.get(0).getOwnerModule();
                }
                HashSet<Module> modules = new HashSet<Module>();
                for (OrderEntry orderEntry : orderEntries) {
                    modules.add(orderEntry.getOwnerModule());
                }
                Module[] candidates = modules.toArray(Module.EMPTY_ARRAY);
                Arrays.sort(candidates, ModuleManager.getInstance(project).moduleDependencyComparator());
                return candidates[0];
            }
            return fileIndex.getModuleForFile(vFile);
        }
        if (containingFile != null) {
            PsiFile file;
            PsiElement context;
            while ((context = containingFile.getContext()) != null && (file = context.getContainingFile()) != null) {
                containingFile = file;
            }
            if (containingFile.getUserData(KEY_MODULE) != null) {
                return (Module)containingFile.getUserData(KEY_MODULE);
            }
            PsiFile originalFile = containingFile.getOriginalFile();
            if (originalFile.getUserData(KEY_MODULE) != null) {
                return (Module)originalFile.getUserData(KEY_MODULE);
            }
            VirtualFile virtualFile3 = originalFile.getVirtualFile();
            if (virtualFile3 != null) {
                return fileIndex.getModuleForFile(virtualFile3);
            }
        }
        return (Module)element.getUserData(KEY_MODULE);
    }

    public static void getDependencies(@NotNull Module module, @NotNull Set<? super Module> modules) {
        Module[] dependencies;
        if (modules.contains(module)) {
            return;
        }
        modules.add(module);
        for (Module dependency : dependencies = ModuleRootManager.getInstance(module).getDependencies()) {
            ModuleUtilCore.getDependencies(dependency, modules);
        }
    }

    public static void collectModulesDependsOn(@NotNull Module module, @NotNull Set<? super Module> result) {
        if (!result.add(module)) {
            return;
        }
        ModuleManager moduleManager = ModuleManager.getInstance(module.getProject());
        List<Module> dependentModules = moduleManager.getModuleDependentModules(module);
        block0: for (Module dependentModule : dependentModules) {
            OrderEntry[] orderEntries;
            for (OrderEntry o : orderEntries = ModuleRootManager.getInstance(dependentModule).getOrderEntries()) {
                ModuleOrderEntry orderEntry;
                if (!(o instanceof ModuleOrderEntry) || (orderEntry = (ModuleOrderEntry)o).getModule() != module) continue;
                if (orderEntry.isExported()) {
                    ModuleUtilCore.collectModulesDependsOn(dependentModule, result);
                    continue block0;
                }
                result.add(dependentModule);
                continue block0;
            }
        }
    }

    @NotNull
    public static List<Module> getAllDependentModules(@NotNull Module module) {
        ArrayList<Module> list = new ArrayList<Module>();
        Graph<Module> graph = ModuleManager.getInstance(module.getProject()).moduleGraph();
        Iterator i = graph.getOut((Object)module);
        while (i.hasNext()) {
            list.add((Module)i.next());
        }
        return list;
    }

    public static boolean visitMeAndDependentModules(@NotNull Module module, @NotNull ModuleVisitor visitor) {
        if (!visitor.visit(module)) {
            return false;
        }
        List<Module> list = ModuleUtilCore.getAllDependentModules(module);
        for (Module dependentModule : list) {
            if (visitor.visit(dependentModule)) continue;
            return false;
        }
        return true;
    }

    public static boolean moduleContainsFile(@NotNull Module module, @NotNull VirtualFile file, boolean isLibraryElement) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
        if (isLibraryElement) {
            OrderEntry orderEntry = moduleRootManager.getFileIndex().getOrderEntryForFile(file);
            return orderEntry instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry;
        }
        return moduleRootManager.getFileIndex().isInContent(file);
    }

    public static boolean isModuleFile(@NotNull Module module, @NotNull VirtualFile file) {
        return FileUtil.namesEqual((String)file.getPath(), (String)module.getModuleFilePath());
    }

    public static boolean isModuleDir(@NotNull Module module, @NotNull VirtualFile dir) {
        return FileUtil.namesEqual((String)dir.getPath(), (String)ModuleUtilCore.getModuleDirPath(module));
    }

    @NotNull
    public static String getModuleDirPath(@NotNull Module module) {
        return PathUtilRt.getParentPath((String)module.getModuleFilePath());
    }

    @FunctionalInterface
    public static interface ModuleVisitor {
        public boolean visit(@NotNull Module var1);
    }
}

