/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.LanguageSyntaxHighlighters;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SingleLazyInstanceSyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.util.KeyedLazyInstance;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SyntaxHighlighterLanguageFactory
extends LanguageExtension<SyntaxHighlighterFactory> {
    public static final ExtensionPointName<KeyedLazyInstance<SyntaxHighlighterFactory>> EP_NAME = new ExtensionPointName("com.intellij.lang.syntaxHighlighterFactory");
    private boolean myEpListenerAdded = false;

    SyntaxHighlighterLanguageFactory() {
        super(EP_NAME, new PlainSyntaxHighlighterFactory());
    }

    @Override
    @NotNull
    protected List<SyntaxHighlighterFactory> buildExtensions(@NotNull String stringKey, @NotNull Language key) {
        List<SyntaxHighlighterFactory> fromEp = super.buildExtensions(stringKey, key);
        if (!fromEp.isEmpty()) {
            return fromEp;
        }
        final SyntaxHighlighter highlighter = (SyntaxHighlighter)LanguageSyntaxHighlighters.INSTANCE.forLanguage(key);
        if (highlighter != null) {
            this.checkAddEPListener();
            return Collections.singletonList(new SingleLazyInstanceSyntaxHighlighterFactory(){

                @Override
                @NotNull
                protected SyntaxHighlighter createHighlighter() {
                    return highlighter;
                }
            });
        }
        return fromEp;
    }

    private synchronized void checkAddEPListener() {
        if (this.myEpListenerAdded) {
            return;
        }
        this.myEpListenerAdded = true;
        LanguageSyntaxHighlighters.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<KeyedLazyInstance<SyntaxHighlighter>>(){

            public void extensionAdded(@NotNull KeyedLazyInstance<SyntaxHighlighter> extension, @NotNull PluginDescriptor pluginDescriptor) {
                SyntaxHighlighterLanguageFactory.this.invalidateCacheForExtension(extension.getKey());
            }

            public void extensionRemoved(@NotNull KeyedLazyInstance<SyntaxHighlighter> extension, @NotNull PluginDescriptor pluginDescriptor) {
                SyntaxHighlighterLanguageFactory.this.invalidateCacheForExtension(extension.getKey());
            }
        }, null);
    }
}

