/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.KeyedLazyInstance;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeEditorHighlighterProviders
extends FileTypeExtension<EditorHighlighterProvider> {
    public static final ExtensionPointName<KeyedLazyInstance<EditorHighlighterProvider>> EP_NAME = ExtensionPointName.create((String)"com.intellij.editorHighlighterProvider");
    public static final FileTypeEditorHighlighterProviders INSTANCE = new FileTypeEditorHighlighterProviders();
    private boolean myEPListenerAdded = false;

    private FileTypeEditorHighlighterProviders() {
        super(EP_NAME);
    }

    @Override
    @NotNull
    protected List<EditorHighlighterProvider> buildExtensions(@NotNull String stringKey, @NotNull FileType key) {
        List<EditorHighlighterProvider> fromEP = super.buildExtensions(stringKey, key);
        if (fromEP.isEmpty()) {
            this.checkAddEPListener();
            EditorHighlighterProvider defaultProvider = new EditorHighlighterProvider(){

                @Override
                public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile2, @NotNull EditorColorsScheme colors) {
                    return EditorHighlighterFactory.getInstance().createEditorHighlighter(SyntaxHighlighterFactory.getSyntaxHighlighter(fileType, project, virtualFile2), colors);
                }
            };
            return Collections.singletonList(defaultProvider);
        }
        return fromEP;
    }

    private synchronized void checkAddEPListener() {
        if (!this.myEPListenerAdded) {
            this.myEPListenerAdded = true;
            SyntaxHighlighter.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<KeyedFactoryEPBean>(){

                public void extensionAdded(@NotNull KeyedFactoryEPBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension.key != null) {
                        FileTypeEditorHighlighterProviders.this.invalidateCacheForExtension(extension.key);
                    }
                }

                public void extensionRemoved(@NotNull KeyedFactoryEPBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension.key != null) {
                        FileTypeEditorHighlighterProviders.this.invalidateCacheForExtension(extension.key);
                    }
                }
            }, null);
        }
    }
}

