/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.EditorDataProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileEditorManager {
    public static final Key<Boolean> USE_CURRENT_WINDOW = Key.create((String)"OpenFile.searchForOpen");
    public static final Key<Boolean> SEPARATOR_DISABLED = Key.create((String)"FileEditorSeparatorDisabled");

    public static FileEditorManager getInstance(@NotNull Project project) {
        return (FileEditorManager)project.getComponent(FileEditorManager.class);
    }

    public abstract FileEditor @NotNull [] openFile(@NotNull VirtualFile var1, boolean var2);

    public FileEditor @NotNull [] openFile(@NotNull VirtualFile file, boolean focusEditor, boolean searchForOpen) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public abstract void closeFile(@NotNull VirtualFile var1);

    @Nullable
    public abstract Editor openTextEditor(@NotNull OpenFileDescriptor var1, boolean var2);

    @Deprecated
    public void navigateToTextEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        this.openTextEditor(descriptor, focusEditor);
    }

    @Nullable
    public abstract Editor getSelectedTextEditor();

    @ApiStatus.Experimental
    public Editor @NotNull [] getSelectedTextEditorWithRemotes() {
        Editor[] editorArray;
        Editor editor = this.getSelectedTextEditor();
        if (editor != null) {
            Editor[] editorArray2 = new Editor[1];
            editorArray = editorArray2;
            editorArray2[0] = editor;
        } else {
            editorArray = Editor.EMPTY_ARRAY;
        }
        return editorArray;
    }

    public abstract boolean isFileOpen(@NotNull VirtualFile var1);

    public abstract VirtualFile @NotNull [] getOpenFiles();

    public boolean hasOpenFiles() {
        return this.getOpenFiles().length > 0;
    }

    public abstract VirtualFile @NotNull [] getSelectedFiles();

    public abstract FileEditor @NotNull [] getSelectedEditors();

    @ApiStatus.Experimental
    public FileEditor @NotNull [] getSelectedEditorWithRemotes() {
        return this.getSelectedEditors();
    }

    @Nullable
    public FileEditor getSelectedEditor() {
        VirtualFile[] files = this.getSelectedFiles();
        return files.length == 0 ? null : this.getSelectedEditor(files[0]);
    }

    @Nullable
    public abstract FileEditor getSelectedEditor(@NotNull VirtualFile var1);

    public abstract FileEditor @NotNull [] getEditors(@NotNull VirtualFile var1);

    public abstract FileEditor @NotNull [] getAllEditors(@NotNull VirtualFile var1);

    public abstract FileEditor @NotNull [] getAllEditors();

    public abstract void addTopComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    public abstract void removeTopComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    public abstract void addBottomComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    public abstract void removeBottomComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    @Deprecated
    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
    }

    @Deprecated
    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2, @NotNull Disposable parentDisposable) {
    }

    @Deprecated
    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
    }

    @NotNull
    public abstract List<FileEditor> openEditor(@NotNull OpenFileDescriptor var1, boolean var2);

    @NotNull
    public abstract Project getProject();

    public abstract void registerExtraEditorDataProvider(@NotNull EditorDataProvider var1, Disposable var2);

    @Nullable
    public abstract Object getData(@NotNull String var1, @NotNull Editor var2, @NotNull Caret var3);

    public abstract void setSelectedEditor(@NotNull VirtualFile var1, @NotNull String var2);

    public abstract void runWhenLoaded(@NotNull Editor var1, @NotNull Runnable var2);
}

