/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.serialization.PropertyMapping;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class TestData
extends AbstractExternalEntityData {
    @NotNull
    private final String testName;
    @NotNull
    private final String testTaskName;
    @NotNull
    private final Set<String> sourceFolders;

    @PropertyMapping(value={"owner", "testName", "testTaskName", "sourceFolders"})
    public TestData(@NotNull ProjectSystemId owner, @NotNull String testName, @NotNull String testTaskName, @NotNull Set<String> sourceFolders) {
        super(owner);
        this.testName = testName;
        this.testTaskName = testTaskName;
        this.sourceFolders = sourceFolders;
    }

    @NotNull
    public String getTestName() {
        return this.testName;
    }

    @NotNull
    public String getTestTaskName() {
        return this.testTaskName;
    }

    @NotNull
    public Set<String> getSourceFolders() {
        return Collections.unmodifiableSet(this.sourceFolders);
    }
}

