/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.PropertyMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectData
extends AbstractNamedData
implements ExternalConfigPathAware,
Identifiable {
    @NotNull
    private final String linkedExternalProjectPath;
    @NotNull
    private String ideProjectFileDirectoryPath;
    @Nullable
    private String description;
    private String group;
    private String version;
    private String ideGrouping;

    @Deprecated
    public ProjectData(@NotNull ProjectSystemId owner, @NotNull String ideProjectFileDirectoryPath, @NotNull String linkedExternalProjectPath) {
        super(owner, "unnamed");
        this.linkedExternalProjectPath = ExternalSystemApiUtil.toCanonicalPath(linkedExternalProjectPath);
        this.ideProjectFileDirectoryPath = ExternalSystemApiUtil.toCanonicalPath(ideProjectFileDirectoryPath);
    }

    @PropertyMapping(value={"owner", "externalName", "ideProjectFileDirectoryPath", "linkedExternalProjectPath"})
    public ProjectData(@NotNull ProjectSystemId owner, @NotNull String externalName, @NotNull String ideProjectFileDirectoryPath, @NotNull String linkedExternalProjectPath) {
        super(owner, externalName);
        this.linkedExternalProjectPath = ExternalSystemApiUtil.toCanonicalPath(linkedExternalProjectPath);
        this.ideProjectFileDirectoryPath = ExternalSystemApiUtil.toCanonicalPath(ideProjectFileDirectoryPath);
    }

    @Override
    @Deprecated
    public void setName(@NotNull String name) {
        super.setExternalName(name);
        super.setInternalName(name);
    }

    @NotNull
    public String getIdeProjectFileDirectoryPath() {
        return this.ideProjectFileDirectoryPath;
    }

    public void setIdeProjectFileDirectoryPath(@NotNull String ideProjectFileDirectoryPath) {
        this.ideProjectFileDirectoryPath = ExternalSystemApiUtil.toCanonicalPath(ideProjectFileDirectoryPath);
    }

    @Override
    @NotNull
    public String getLinkedExternalProjectPath() {
        return this.linkedExternalProjectPath;
    }

    @Nullable
    public String getIdeGrouping() {
        return this.ideGrouping;
    }

    public void setIdeGrouping(@Nullable String ideGrouping) {
        this.ideGrouping = ideGrouping;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.ideProjectFileDirectoryPath.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectData project = (ProjectData)o;
        return this.ideProjectFileDirectoryPath.equals(project.ideProjectFileDirectoryPath);
    }

    public String toString() {
        return String.format("%s project '%s'", StringUtil.toLowerCase((String)this.getOwner().toString()), this.getExternalName());
    }

    @Override
    @NotNull
    public String getId() {
        return "";
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }
}

