/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.serialization.PropertyMapping;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public final class Key<T>
implements Comparable<Key<?>>,
Serializable {
    @NotNull
    private final String dataClass;
    private final int processingWeight;

    @PropertyMapping(value={"dataClass", "processingWeight"})
    public Key(@NotNull String dataClass, int processingWeight) {
        this.dataClass = dataClass;
        this.processingWeight = processingWeight;
    }

    @NotNull
    public static <T> Key<T> create(@NotNull Class<T> dataClass, int processingWeight) {
        return new Key<T>(dataClass.getName(), processingWeight);
    }

    @NotNull
    public String getDataType() {
        return this.dataClass;
    }

    public int getProcessingWeight() {
        return this.processingWeight;
    }

    public int hashCode() {
        return this.dataClass.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        return this.dataClass.equals(key.dataClass);
    }

    @Override
    public int compareTo(@NotNull Key<?> that) {
        if (this.processingWeight == that.processingWeight) {
            return this.dataClass.compareTo(that.dataClass);
        }
        return this.processingWeight - that.processingWeight;
    }

    public String toString() {
        int i = this.dataClass.lastIndexOf(46);
        return i > 0 ? this.dataClass.substring(i + 1) : this.dataClass;
    }
}

