/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ImportSpecImpl
implements ImportSpec {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private ProgressExecutionMode myProgressExecutionMode;
    private boolean forceWhenUptodate;
    @Nullable
    private ExternalProjectRefreshCallback myCallback;
    private boolean isPreviewMode;
    private boolean createDirectoriesForEmptyContentRoots;
    private boolean isReportRefreshError;
    @Nullable
    private String myVmOptions;
    @Nullable
    private String myArguments;
    @Nullable
    private ProjectResolverPolicy myProjectResolverPolicy;

    public ImportSpecImpl(@NotNull Project project, @NotNull ProjectSystemId id) {
        this.myProject = project;
        this.myExternalSystemId = id;
        this.myProgressExecutionMode = ProgressExecutionMode.MODAL_SYNC;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return this.myExternalSystemId;
    }

    @Override
    @NotNull
    public ProgressExecutionMode getProgressExecutionMode() {
        return this.myProgressExecutionMode;
    }

    public void setProgressExecutionMode(@NotNull ProgressExecutionMode progressExecutionMode) {
        this.myProgressExecutionMode = progressExecutionMode;
    }

    @Override
    public boolean isForceWhenUptodate() {
        return this.forceWhenUptodate;
    }

    public void setForceWhenUptodate(boolean forceWhenUptodate) {
        this.forceWhenUptodate = forceWhenUptodate;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setWhenAutoImportEnabled(boolean whenAutoImportEnabled) {
    }

    public void setCallback(@Nullable ExternalProjectRefreshCallback callback) {
        this.myCallback = callback;
    }

    @Override
    @Nullable
    public ExternalProjectRefreshCallback getCallback() {
        return this.myCallback;
    }

    @Override
    public boolean isPreviewMode() {
        return this.isPreviewMode;
    }

    public void setPreviewMode(boolean isPreviewMode) {
        this.isPreviewMode = isPreviewMode;
    }

    @Override
    public boolean shouldCreateDirectoriesForEmptyContentRoots() {
        return this.createDirectoriesForEmptyContentRoots;
    }

    public void setCreateDirectoriesForEmptyContentRoots(boolean createDirectoriesForEmptyContentRoots) {
        this.createDirectoriesForEmptyContentRoots = createDirectoriesForEmptyContentRoots;
    }

    @Override
    public boolean isReportRefreshError() {
        return this.isReportRefreshError;
    }

    public void setReportRefreshError(boolean isReportRefreshError) {
        this.isReportRefreshError = isReportRefreshError;
    }

    @Override
    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    public void setVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    @Override
    @Nullable
    public String getArguments() {
        return this.myArguments;
    }

    public void setArguments(@Nullable String arguments) {
        this.myArguments = arguments;
    }

    @Nullable
    public ProjectResolverPolicy getProjectResolverPolicy() {
        return this.myProjectResolverPolicy;
    }

    void setProjectResolverPolicy(@Nullable ProjectResolverPolicy projectResolverPolicy) {
        this.myProjectResolverPolicy = projectResolverPolicy;
    }
}

