/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextAttributesEffectsBuilder {
    private static final Logger LOG = Logger.getInstance(TextAttributesEffectsBuilder.class);
    private static final Map<EffectType, EffectSlot> EFFECT_SLOTS_MAP = ContainerUtil.immutableMapBuilder().put((Object)EffectType.STRIKEOUT, (Object)EffectSlot.STRIKE_SLOT).put((Object)EffectType.BOXED, (Object)EffectSlot.FRAME_SLOT).put((Object)EffectType.ROUNDED_BOX, (Object)EffectSlot.FRAME_SLOT).put((Object)EffectType.SLIGHTLY_WIDER_BOX, (Object)EffectSlot.FRAME_SLOT).put((Object)EffectType.BOLD_LINE_UNDERSCORE, (Object)EffectSlot.UNDERLINE_SLOT).put((Object)EffectType.LINE_UNDERSCORE, (Object)EffectSlot.UNDERLINE_SLOT).put((Object)EffectType.WAVE_UNDERSCORE, (Object)EffectSlot.UNDERLINE_SLOT).put((Object)EffectType.BOLD_DOTTED_LINE, (Object)EffectSlot.UNDERLINE_SLOT).build();
    private final Map<EffectSlot, EffectDescriptor> myEffectsMap = new HashMap<EffectSlot, EffectDescriptor>(EffectSlot.values().length);

    private TextAttributesEffectsBuilder() {
    }

    @NotNull
    public static TextAttributesEffectsBuilder create() {
        return new TextAttributesEffectsBuilder();
    }

    @NotNull
    public static TextAttributesEffectsBuilder create(@NotNull TextAttributes deepestAttributes) {
        return TextAttributesEffectsBuilder.create().coverWith(deepestAttributes);
    }

    @NotNull
    public final TextAttributesEffectsBuilder coverWith(@NotNull TextAttributes attributes) {
        attributes.forEachAdditionalEffect(this::coverWith);
        this.coverWith(attributes.getEffectType(), attributes.getEffectColor());
        return this;
    }

    @NotNull
    public final TextAttributesEffectsBuilder slipUnder(@NotNull TextAttributes attributes) {
        this.slipUnder(attributes.getEffectType(), attributes.getEffectColor());
        attributes.forEachAdditionalEffect(this::slipUnder);
        return this;
    }

    @NotNull
    public TextAttributesEffectsBuilder coverWith(@Nullable EffectType effectType, @Nullable Color effectColor) {
        return this.mutateBuilder(effectType, effectColor, this.myEffectsMap::put);
    }

    @NotNull
    public TextAttributesEffectsBuilder slipUnder(@Nullable EffectType effectType, @Nullable Color effectColor) {
        return this.mutateBuilder(effectType, effectColor, this.myEffectsMap::putIfAbsent);
    }

    @NotNull
    private TextAttributesEffectsBuilder mutateBuilder(@Nullable EffectType effectType, @Nullable Color effectColor, @NotNull BiConsumer<? super EffectSlot, ? super EffectDescriptor> slotMutator) {
        if (effectColor != null && effectType != null) {
            EffectSlot slot = EFFECT_SLOTS_MAP.get((Object)effectType);
            if (slot != null) {
                slotMutator.accept(slot, EffectDescriptor.create(effectType, effectColor));
            } else {
                LOG.debug("Effect " + (Object)((Object)effectType) + " is not supported by builder");
            }
        }
        return this;
    }

    @NotNull
    Map<EffectType, Color> getEffectsMap() {
        if (this.myEffectsMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<EffectType, Color> result = new HashMap<EffectType, Color>();
        this.myEffectsMap.forEach((key, val) -> {
            if (val != null) {
                result.put(val.effectType, val.effectColor);
            }
        });
        return result;
    }

    @NotNull
    public TextAttributes applyTo(@NotNull TextAttributes targetAttributes) {
        Iterator<EffectDescriptor> effectsIterator = this.myEffectsMap.values().iterator();
        if (!effectsIterator.hasNext()) {
            targetAttributes.setEffectColor(null);
            targetAttributes.setEffectType(EffectType.BOXED);
            targetAttributes.setAdditionalEffects(Collections.emptyMap());
        } else {
            EffectDescriptor mainEffectDescriptor = effectsIterator.next();
            targetAttributes.setEffectType(mainEffectDescriptor.effectType);
            targetAttributes.setEffectColor(mainEffectDescriptor.effectColor);
            int effectsLeft = this.myEffectsMap.size() - 1;
            if (effectsLeft == 0) {
                targetAttributes.setAdditionalEffects(Collections.emptyMap());
            } else if (effectsLeft == 1) {
                EffectDescriptor additionalEffect = effectsIterator.next();
                targetAttributes.setAdditionalEffects(Collections.singletonMap(additionalEffect.effectType, additionalEffect.effectColor));
            } else {
                HashMap<EffectType, Color> effectsMap = new HashMap<EffectType, Color>(effectsLeft);
                effectsIterator.forEachRemaining(it -> effectsMap.put(it.effectType, it.effectColor));
                targetAttributes.setAdditionalEffects(effectsMap);
            }
        }
        return targetAttributes;
    }

    @Nullable
    @Contract(value="null -> null")
    public EffectDescriptor getEffectDescriptor(@Nullable EffectSlot effectSlot) {
        return this.myEffectsMap.get((Object)effectSlot);
    }

    public static class EffectDescriptor {
        @NotNull
        public final EffectType effectType;
        @NotNull
        public final Color effectColor;

        private EffectDescriptor(@NotNull EffectType effectType, @NotNull Color effectColor) {
            this.effectType = effectType;
            this.effectColor = effectColor;
        }

        @NotNull
        static EffectDescriptor create(@NotNull EffectType effectType, @NotNull Color effectColor) {
            return new EffectDescriptor(effectType, effectColor);
        }
    }

    public static enum EffectSlot {
        FRAME_SLOT,
        UNDERLINE_SLOT,
        STRIKE_SLOT;

    }
}

