/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.event;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorMouseEvent
extends EventObject {
    @NotNull
    private final MouseEvent myMouseEvent;
    private final EditorMouseEventArea myEditorArea;
    private final int myOffset;
    private final LogicalPosition myLogicalPosition;
    private final VisualPosition myVisualPosition;
    private final boolean myIsOverText;
    private final FoldRegion myCollapsedFoldRegion;
    private final Inlay myInlay;
    private final GutterIconRenderer myGutterIconRenderer;

    public EditorMouseEvent(@NotNull Editor editor, @NotNull MouseEvent mouseEvent, EditorMouseEventArea area) {
        this(editor, mouseEvent, area, 0, new LogicalPosition(0, 0), new VisualPosition(0, 0), true, null, null, null);
    }

    public EditorMouseEvent(@NotNull Editor editor, @NotNull MouseEvent mouseEvent, EditorMouseEventArea area, int offset, @NotNull LogicalPosition logicalPosition, @NotNull VisualPosition visualPosition, boolean isOverText, FoldRegion collapsedFoldRegion, Inlay inlay, GutterIconRenderer gutterIconRenderer) {
        super(editor);
        this.myMouseEvent = mouseEvent;
        this.myEditorArea = area;
        this.myOffset = offset;
        this.myLogicalPosition = logicalPosition;
        this.myVisualPosition = visualPosition;
        this.myIsOverText = isOverText;
        this.myCollapsedFoldRegion = collapsedFoldRegion;
        this.myInlay = inlay;
        this.myGutterIconRenderer = gutterIconRenderer;
    }

    @NotNull
    public Editor getEditor() {
        return (Editor)this.getSource();
    }

    @NotNull
    public MouseEvent getMouseEvent() {
        return this.myMouseEvent;
    }

    public void consume() {
        this.myMouseEvent.consume();
    }

    public boolean isConsumed() {
        return this.myMouseEvent.isConsumed();
    }

    public EditorMouseEventArea getArea() {
        return this.myEditorArea;
    }

    public int getOffset() {
        return this.myOffset;
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        return this.myLogicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        return this.myVisualPosition;
    }

    public boolean isOverText() {
        return this.myIsOverText;
    }

    @Nullable
    public FoldRegion getCollapsedFoldRegion() {
        return this.myCollapsedFoldRegion == null || !this.myCollapsedFoldRegion.isValid() ? null : this.myCollapsedFoldRegion;
    }

    @Nullable
    public Inlay getInlay() {
        return this.myInlay == null || !this.myInlay.isValid() ? null : this.myInlay;
    }

    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }
}

