/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.ColorUtil;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class EditorColorsManager {
    public static final Topic<EditorColorsListener> TOPIC = new Topic(EditorColorsListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);
    @NonNls
    public static final String DEFAULT_SCHEME_NAME = "Default";
    @NonNls
    public static final String COLOR_SCHEME_FILE_EXTENSION = ".icls";

    public static EditorColorsManager getInstance() {
        return (EditorColorsManager)ApplicationManager.getApplication().getService(EditorColorsManager.class);
    }

    public abstract void addColorsScheme(@NotNull EditorColorsScheme var1);

    @Deprecated
    public abstract void removeAllSchemes();

    public abstract EditorColorsScheme @NotNull [] getAllSchemes();

    public abstract void setGlobalScheme(EditorColorsScheme var1);

    @NotNull
    public abstract EditorColorsScheme getGlobalScheme();

    public abstract EditorColorsScheme getScheme(@NotNull String var1);

    public abstract boolean isDefaultScheme(EditorColorsScheme var1);

    @Deprecated
    public final void addEditorColorsListener(@NotNull EditorColorsListener listener2) {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(TOPIC, (Object)listener2);
    }

    @Deprecated
    public final void addEditorColorsListener(@NotNull EditorColorsListener listener2, @NotNull Disposable disposable) {
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(TOPIC, (Object)listener2);
    }

    public abstract boolean isUseOnlyMonospacedFonts();

    public abstract void setUseOnlyMonospacedFonts(boolean var1);

    @NotNull
    public EditorColorsScheme getSchemeForCurrentUITheme() {
        return this.getGlobalScheme();
    }

    public boolean isDarkEditor() {
        Color bg = this.getGlobalScheme().getDefaultBackground();
        return ColorUtil.isDark((Color)bg);
    }

    public void resolveSchemeParent(@NotNull EditorColorsScheme scheme) {
    }
}

