/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.MultiMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorColorPalette {
    protected final EditorColorsScheme myColorsScheme;
    private final MultiMap<Color, TextAttributesKey> myColors = new MultiMap();
    public static final Comparator<Color> ORDER_NONE = Comparator.comparingInt(EditorColorPalette::getDefaultOrder);
    public static final Comparator<Color> ORDER_BY_INTENSITY = Comparator.comparingInt(EditorColorPalette::getIntensity);

    public EditorColorPalette(EditorColorsScheme colorsScheme) {
        this.myColorsScheme = colorsScheme;
    }

    public EditorColorPalette withBackgroundColors() {
        return this.collectColors((Function<? super TextAttributes, ? extends Color>)((Function)attr -> attr.getBackgroundColor()));
    }

    public EditorColorPalette withForegroundColors() {
        return this.collectColors((Function<? super TextAttributes, ? extends Color>)((Function)attr -> attr.getForegroundColor()));
    }

    private Collection<Color> orderBy(@Nullable Comparator<? super Color> comparator) {
        ArrayList<Color> sorted = new ArrayList<Color>(this.myColors.keySet());
        sorted.sort(comparator);
        return sorted;
    }

    private static int getIntensity(@NotNull Color color) {
        return (color.getRed() + color.getGreen() + color.getBlue()) / 3;
    }

    @Contract(pure=true)
    private static int getDefaultOrder(@NotNull Color color) {
        return 0;
    }

    public Collection<Color> getColors(@NotNull Comparator<? super Color> comparator) {
        return comparator == ORDER_NONE ? this.myColors.keySet() : this.orderBy(comparator);
    }

    @NotNull
    public Set<Map.Entry<Color, Collection<TextAttributesKey>>> getEntries() {
        return this.myColors.entrySet();
    }

    public EditorColorPalette collectColors(@NotNull Function<? super TextAttributes, ? extends Color> attrColorReader) {
        return this.collectColorsWithFilter(attrColorReader, false);
    }

    public EditorColorPalette collectColorsWithFilter(@NotNull Function<? super TextAttributes, ? extends Color> attrColorReader, boolean filterOutRainbowAttrKeys) {
        MultiMap colors = new MultiMap();
        for (TextAttributesKey key : this.getTextAttributeKeys(filterOutRainbowAttrKeys)) {
            Color usedColor;
            TextAttributes attributes = this.myColorsScheme.getAttributes(key);
            if (attributes == null || (usedColor = (Color)attrColorReader.fun((Object)attributes)) == null) continue;
            colors.putValue((Object)usedColor, (Object)key);
        }
        this.myColors.putAllValues(colors);
        return this;
    }

    @Nullable
    public Color getClosestNonConflictingColor(@NotNull Color sampleColor) {
        boolean searchBrighter = ColorUtil.isDark((Color)sampleColor);
        Color foundColor = this.getClosestNonConflictingColor(sampleColor, EditorColorPalette.getAdjuster(searchBrighter));
        if (foundColor == null) {
            foundColor = this.getClosestNonConflictingColor(sampleColor, EditorColorPalette.getAdjuster(!searchBrighter));
        }
        return foundColor;
    }

    @Contract(pure=true)
    private static Function<Color, Color> getAdjuster(boolean searchBrighter) {
        return searchBrighter ? Color::brighter : Color::darker;
    }

    @Nullable
    public Color getClosestNonConflictingColor(@NotNull Color sampleColor, @NotNull Function<? super Color, ? extends Color> colorAdjuster) {
        if (this.myColors.containsKey((Object)sampleColor)) {
            Color newColor = (Color)colorAdjuster.fun((Object)sampleColor);
            return !sampleColor.equals(newColor) ? this.getClosestNonConflictingColor(newColor, colorAdjuster) : null;
        }
        return sampleColor;
    }

    protected abstract Collection<TextAttributesKey> getTextAttributeKeys(boolean var1);
}

