/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.FontPreferences;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class DelegatingFontPreferences
extends FontPreferences {
    private final Supplier<? extends FontPreferences> myDelegateSupplier;

    public DelegatingFontPreferences(@NotNull Supplier<? extends FontPreferences> delegateSupplier) {
        this.myDelegateSupplier = delegateSupplier;
    }

    @Override
    @NotNull
    public List<String> getEffectiveFontFamilies() {
        return this.myDelegateSupplier.get().getEffectiveFontFamilies();
    }

    @Override
    @NotNull
    public List<String> getRealFontFamilies() {
        return this.myDelegateSupplier.get().getRealFontFamilies();
    }

    @Override
    @NotNull
    public String getFontFamily() {
        return this.myDelegateSupplier.get().getFontFamily();
    }

    @Override
    public int getSize(@NotNull String fontFamily) {
        return this.myDelegateSupplier.get().getSize(fontFamily);
    }

    @Override
    public void copyTo(@NotNull FontPreferences preferences) {
        this.myDelegateSupplier.get().copyTo(preferences);
    }

    @Override
    public boolean useLigatures() {
        return this.myDelegateSupplier.get().useLigatures();
    }

    @Override
    public boolean hasSize(@NotNull String fontName) {
        return this.myDelegateSupplier.get().hasSize(fontName);
    }

    @Override
    public float getLineSpacing() {
        return this.myDelegateSupplier.get().getLineSpacing();
    }
}

