/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionHandlerBean;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DynamicEditorActionHandler
extends EditorActionHandler {
    private static final List<EditorActionHandler> UPDATE_MARKER = new ArrayList<EditorActionHandler>();
    private final EditorAction myAction;
    private final EditorActionHandler myBaseHandler;
    private final AtomicReference<List<EditorActionHandler>> myCachedChain = new AtomicReference();
    private boolean myWorksInInjected;

    DynamicEditorActionHandler(@NotNull EditorAction editorAction, @NotNull EditorActionHandler baseHandler) {
        this.myAction = editorAction;
        this.myBaseHandler = baseHandler;
    }

    @Override
    public boolean runForAllCarets() {
        return this.getHandler().runForAllCarets();
    }

    @Override
    public boolean isEnabled(Editor editor, DataContext dataContext) {
        return this.getHandler().isEnabled(editor, dataContext);
    }

    @Override
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        return this.getHandler().isEnabledForCaret(editor, caret, dataContext);
    }

    @Override
    public void execute(@NotNull Editor editor, @Nullable DataContext dataContext) {
        this.getHandler().execute(editor, dataContext);
    }

    @Override
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        this.getHandler().doExecute(editor, caret, dataContext);
    }

    @Override
    public boolean executeInCommand(@NotNull Editor editor, DataContext dataContext) {
        return this.getHandler().executeInCommand(editor, dataContext);
    }

    @Override
    public DocCommandGroupId getCommandGroupId(@NotNull Editor editor) {
        return this.getHandler().getCommandGroupId(editor);
    }

    @Override
    synchronized void setWorksInInjected(boolean worksInInjected) {
        super.setWorksInInjected(worksInInjected);
        this.myWorksInInjected = worksInInjected;
        this.clearCache();
    }

    @Override
    @Nullable
    <T> T getHandlerOfType(@NotNull Class<T> type) {
        List<EditorActionHandler> chain = this.getHandlerChain();
        for (int i = chain.size() - 1; i >= 0; --i) {
            T handler = chain.get(i).getHandlerOfType(type);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    private EditorActionHandler getHandler() {
        return (EditorActionHandler)ContainerUtil.getLastItem(this.getHandlerChain());
    }

    private synchronized List<EditorActionHandler> getHandlerChain() {
        List<EditorActionHandler> cachedChain = this.myCachedChain.get();
        if (cachedChain != null && cachedChain != UPDATE_MARKER) {
            return cachedChain;
        }
        this.myCachedChain.set(UPDATE_MARKER);
        List<EditorActionHandlerBean> handlerBeans = ActionManagerEx.getInstanceEx().getRegisteredHandlers(this.myAction);
        ArrayList<EditorActionHandler> chain = new ArrayList<EditorActionHandler>(handlerBeans.size());
        chain.add(this.myBaseHandler);
        for (EditorActionHandlerBean handlerBean : handlerBeans) {
            EditorActionHandler handler = handlerBean.getHandler((EditorActionHandler)ContainerUtil.getLastItem(chain));
            if (handler == null) continue;
            handler.setWorksInInjected(this.myWorksInInjected);
            chain.add(handler);
        }
        this.myCachedChain.compareAndSet(UPDATE_MARKER, chain);
        return chain;
    }

    void clearCache() {
        this.myCachedChain.set(null);
    }
}

