/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServiceManager {
    private ServiceManager() {
    }

    public static <T> T getService(@NotNull Class<T> serviceClass) {
        return (T)ApplicationManager.getApplication().getService(serviceClass);
    }

    public static <T> T getService(@NotNull Project project, @NotNull Class<T> serviceClass) {
        return (T)project.getService(serviceClass);
    }

    @Deprecated
    @Nullable
    public static <T> T getServiceIfCreated(@NotNull Project project, @NotNull Class<T> serviceClass) {
        return (T)project.getServiceIfCreated(serviceClass);
    }

    @Deprecated
    @Nullable
    public static <T> T getServiceIfCreated(@NotNull Class<T> serviceClass) {
        return (T)ApplicationManager.getApplication().getServiceIfCreated(serviceClass);
    }

    @Deprecated
    @NotNull
    public static <T> NotNullLazyKey<T, Project> createLazyKey(@NotNull Class<? extends T> serviceClass) {
        return NotNullLazyKey.create((String)("Service: " + serviceClass.getName()), project -> project.getService(serviceClass));
    }
}

