/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public final class UndoUtil {
    private UndoUtil() {
    }

    public static void markPsiFileForUndo(@NotNull PsiFile file) {
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance(project).getDocument(file);
        if (document == null) {
            return;
        }
        CommandProcessor.getInstance().addAffectedDocuments(project, document);
    }

    public static void disableUndoFor(@NotNull Document document) {
        document.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
    }

    public static boolean isUndoDisabledFor(@NotNull Document document) {
        return Boolean.TRUE.equals(document.getUserData(UndoConstants.DONT_RECORD_UNDO));
    }
}

