/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public final class WriteThread {
    private WriteThread() {
    }

    @NotNull
    public static Future<Void> submit(@NotNull Runnable runnable) {
        return WriteThread.submit(() -> {
            runnable.run();
            return null;
        });
    }

    @NotNull
    public static <T> Future<T> submit(@NotNull ThrowableComputable<? extends T, ?> computable) {
        CompletableFuture future = new CompletableFuture();
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
            try {
                future.complete(computable.compute());
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    public static void invokeAndWait(@NotNull Runnable runnable) {
        try {
            WriteThread.submit(runnable).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            ExceptionUtil.rethrowUnchecked((Throwable)e.getCause());
        }
    }
}

