/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ExceptionUtil;
import org.jetbrains.annotations.NotNull;

public final class RunResult<T>
extends Result<T> {
    private BaseActionRunnable<T> myActionRunnable;
    private Throwable myThrowable;

    protected RunResult() {
    }

    public RunResult(@NotNull BaseActionRunnable<T> action) {
        this.myActionRunnable = action;
    }

    public RunResult<T> run() {
        try {
            this.myActionRunnable.run(this);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            this.myThrowable = t;
            if (!this.myActionRunnable.isSilentExecution()) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
            }
        }
        finally {
            this.myActionRunnable = null;
        }
        return this;
    }

    public T getResultObject() {
        return (T)this.myResult;
    }

    @NotNull
    public RunResult logException(Logger logger) {
        if (this.myThrowable != null) {
            logger.error(this.myThrowable);
        }
        return this;
    }

    @NotNull
    public RunResult<T> throwException() throws RuntimeException, Error {
        if (this.myThrowable != null) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)this.myThrowable);
        }
        return this;
    }

    public boolean hasException() {
        return this.myThrowable != null;
    }

    public Throwable getThrowable() {
        return this.myThrowable;
    }

    public void setThrowable(Exception throwable) {
        this.myThrowable = throwable;
    }
}

