/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.Presentation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface Toggleable {
    @ApiStatus.Internal
    @NonNls
    public static final String SELECTED_PROPERTY = "selected";

    @Contract(pure=true)
    public static boolean isSelected(@NotNull Presentation presentation) {
        Object property = presentation.getClientProperty(SELECTED_PROPERTY);
        if (property != null && !(property instanceof Boolean)) {
            throw new IllegalStateException("Unexpected value for 'selected': " + property + "; presentation=" + presentation);
        }
        return property != null && (Boolean)property != false;
    }

    public static void setSelected(@NotNull Presentation presentation, boolean selected) {
        presentation.putClientProperty(SELECTED_PROPERTY, (Object)selected);
    }
}

