/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.util.NlsActions;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToggleAction
extends AnAction
implements Toggleable {
    public ToggleAction() {
    }

    public ToggleAction(@Nullable @NlsActions.ActionText String text) {
        super(() -> text);
    }

    public ToggleAction(@NotNull Supplier<String> text) {
        super(text);
    }

    public ToggleAction(@Nullable @NlsActions.ActionText String text, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public ToggleAction(@NotNull Supplier<String> text, @NotNull Supplier<String> description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public ToggleAction(@NotNull Supplier<String> text, @Nullable Icon icon) {
        super(text, Presentation.NULL_STRING, icon);
    }

    @Override
    public final void actionPerformed(@NotNull AnActionEvent e) {
        boolean state = !this.isSelected(e);
        this.setSelected(e, state);
        Presentation presentation = e.getPresentation();
        Toggleable.setSelected(presentation, state);
    }

    public abstract boolean isSelected(@NotNull AnActionEvent var1);

    public abstract void setSelected(@NotNull AnActionEvent var1, boolean var2);

    @Override
    public void update(@NotNull AnActionEvent e) {
        boolean selected = this.isSelected(e);
        Presentation presentation = e.getPresentation();
        Toggleable.setSelected(presentation, selected);
        if (e.isFromContextMenu()) {
            presentation.setIcon(null);
        }
    }
}

