/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionInGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultActionGroup
extends ActionGroup {
    private static final Logger LOG = Logger.getInstance(DefaultActionGroup.class);
    private static final String CANT_ADD_ITSELF = "Cannot add a group to itself: ";
    private static final String CANT_ADD_ACTION_TWICE = "Cannot add an action twice: ";
    private final List<AnAction> mySortedChildren = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Pair<AnAction, Constraints>> myPairs = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myModificationStamp;

    public DefaultActionGroup() {
        this(Presentation.NULL_STRING, false);
    }

    public DefaultActionGroup(AnAction ... actions) {
        this(Arrays.asList(actions));
    }

    public DefaultActionGroup(@NotNull List<? extends AnAction> actions) {
        this(Presentation.NULL_STRING, actions);
    }

    public DefaultActionGroup(@NotNull Supplier<@NlsActions.ActionText String> name, @NotNull List<? extends AnAction> actions) {
        this(name, false);
        this.addActions(actions);
    }

    public DefaultActionGroup(@Nullable @NlsActions.ActionText String name, @NotNull List<? extends AnAction> actions) {
        this(() -> name, actions);
    }

    public DefaultActionGroup(@Nullable @NlsActions.ActionText String shortName, boolean popup) {
        this(() -> shortName, popup);
    }

    protected DefaultActionGroup(@NotNull Supplier<@NlsActions.ActionText String> shortName, boolean popup) {
        super(shortName, popup);
    }

    public static DefaultActionGroup createPopupGroup(@NotNull Supplier<@NlsActions.ActionText String> shortName) {
        return new DefaultActionGroup(shortName, true);
    }

    public static DefaultActionGroup createFlatGroup(@NotNull Supplier<@NlsActions.ActionText String> shortName) {
        return new DefaultActionGroup(shortName, false);
    }

    public static DefaultActionGroup createPopupGroupWithEmptyText() {
        return DefaultActionGroup.createPopupGroup(() -> "");
    }

    private void incrementModificationStamp() {
        ++this.myModificationStamp;
    }

    public int getModificationStamp() {
        return this.myModificationStamp;
    }

    private void addActions(@NotNull List<? extends AnAction> actions) {
        HashSet<AnAction> actionSet = new HashSet<AnAction>();
        ArrayList<AnAction> uniqueActions = new ArrayList<AnAction>(actions.size());
        for (AnAction anAction : actions) {
            if (anAction == this) {
                throw new IllegalArgumentException(CANT_ADD_ITSELF + anAction);
            }
            if (!(anAction instanceof Separator) && !actionSet.add(anAction)) {
                LOG.error(CANT_ADD_ACTION_TWICE + anAction);
                continue;
            }
            uniqueActions.add(anAction);
        }
        this.mySortedChildren.addAll(uniqueActions);
        this.incrementModificationStamp();
    }

    public final void add(@NotNull AnAction action, @NotNull ActionManager actionManager) {
        this.add(action, Constraints.LAST, actionManager);
    }

    public final void add(@NotNull AnAction action) {
        this.addAction(action, Constraints.LAST);
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action) {
        return this.addAction(action, Constraints.LAST);
    }

    public final void addSeparator() {
        this.add(Separator.create());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint) {
        this.add(action, constraint, ActionManager.getInstance());
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint) {
        return this.addAction(action, constraint, ActionManager.getInstance());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        this.addAction(action, constraint, actionManager);
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == this) {
            throw new IllegalArgumentException(CANT_ADD_ITSELF + action);
        }
        if (!(action instanceof Separator) && this.containsAction(action)) {
            LOG.error(CANT_ADD_ACTION_TWICE + action);
            this.remove(action, actionManager.getId(action));
        }
        constraint = (Constraints)constraint.clone();
        if (constraint.myAnchor == Anchor.FIRST) {
            this.mySortedChildren.add(0, action);
        } else if (constraint.myAnchor == Anchor.LAST) {
            this.mySortedChildren.add(action);
        } else {
            this.myPairs.add((Pair<AnAction, Constraints>)Pair.create((Object)action, (Object)constraint));
        }
        this.addAllToSortedList(actionManager);
        this.incrementModificationStamp();
        return new ActionInGroup(this, action);
    }

    private boolean containsAction(@NotNull AnAction action) {
        if (this.mySortedChildren.contains(action)) {
            return true;
        }
        for (Pair<AnAction, Constraints> pair : this.myPairs) {
            if (!action.equals(pair.first)) continue;
            return true;
        }
        return false;
    }

    private void addAllToSortedList(@NotNull ActionManager actionManager) {
        block0: while (!this.myPairs.isEmpty()) {
            for (int i = 0; i < this.myPairs.size(); ++i) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i);
                if (!this.addToSortedList((AnAction)pair.first, (Constraints)pair.second, actionManager)) continue;
                this.myPairs.remove(i);
                continue block0;
            }
        }
    }

    private boolean addToSortedList(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        int index = DefaultActionGroup.findIndex(constraint.myRelativeToActionId, this.mySortedChildren, actionManager);
        if (index == -1) {
            return false;
        }
        if (constraint.myAnchor == Anchor.BEFORE) {
            this.mySortedChildren.add(index, action);
        } else {
            this.mySortedChildren.add(index + 1, action);
        }
        return true;
    }

    private static int findIndex(String actionId, @NotNull List<? extends AnAction> actions, @NotNull ActionManager actionManager) {
        for (int i = 0; i < actions.size(); ++i) {
            String id;
            AnAction action = actions.get(i);
            if (!(action instanceof ActionStub ? ((ActionStub)action).getId().equals(actionId) : (id = actionManager.getId(action)) != null && id.equals(actionId))) continue;
            return i;
        }
        return -1;
    }

    public final void remove(@NotNull AnAction action) {
        this.remove(action, ActionManager.getInstance());
    }

    public final void remove(@NotNull AnAction action, @NotNull ActionManager actionManager) {
        this.remove(action, actionManager.getId(action));
    }

    public final void remove(@NotNull AnAction action, @Nullable String id) {
        if (!this.mySortedChildren.remove(action) && !this.mySortedChildren.removeIf(oldAction -> oldAction instanceof ActionStubBase && ((ActionStubBase)((Object)oldAction)).getId().equals(id))) {
            for (int i = 0; i < this.myPairs.size(); ++i) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i);
                if (!((AnAction)pair.first).equals(action) && (!(pair.first instanceof ActionStubBase) || !((ActionStubBase)pair.first).getId().equals(id))) continue;
                this.myPairs.remove(i);
                this.incrementModificationStamp();
                break;
            }
        }
    }

    public final void removeAll() {
        this.mySortedChildren.clear();
        this.myPairs.clear();
        this.incrementModificationStamp();
    }

    public boolean replaceAction(@NotNull AnAction oldAction, @NotNull AnAction newAction) {
        int index = this.mySortedChildren.indexOf(oldAction);
        if (index >= 0) {
            this.mySortedChildren.set(index, newAction);
            this.incrementModificationStamp();
            return true;
        }
        for (int i = 0; i < this.myPairs.size(); ++i) {
            Pair<AnAction, Constraints> pair = this.myPairs.get(i);
            if (!((AnAction)pair.first).equals(newAction)) continue;
            this.myPairs.set(i, (Pair<AnAction, Constraints>)Pair.create((Object)newAction, (Object)pair.second));
            this.incrementModificationStamp();
            return true;
        }
        return false;
    }

    public void copyFromGroup(@NotNull DefaultActionGroup other) {
        this.copyFrom(other);
        this.setPopup(other.isPopup());
        this.mySortedChildren.clear();
        this.mySortedChildren.addAll(other.mySortedChildren);
        this.myPairs.clear();
        this.myPairs.addAll(other.myPairs);
        this.incrementModificationStamp();
    }

    @Override
    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        return this.getChildren(e, e != null ? e.getActionManager() : ActionManager.getInstance());
    }

    @Override
    public final AnAction @NotNull [] getChildren(@Nullable AnActionEvent e, @NotNull ActionManager actionManager) {
        int i;
        boolean hasNulls = false;
        int sortedSize = this.mySortedChildren.size();
        Object[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i = 0; i < sortedSize; ++i) {
            AnAction action = this.mySortedChildren.get(i);
            if (action == null) {
                LOG.error("Empty sorted child: " + this + ", " + this.getClass() + "; index=" + i);
            }
            if (action instanceof ActionStubBase) {
                if ((action = this.unStub(actionManager, (ActionStubBase)((Object)action))) == null) {
                    LOG.error("Can't unstub " + this.mySortedChildren.get(i));
                } else {
                    this.mySortedChildren.set(i, action);
                }
            }
            hasNulls |= action == null;
            children[i] = action;
        }
        for (i = 0; i < this.myPairs.size(); ++i) {
            Pair<AnAction, Constraints> pair = this.myPairs.get(i);
            AnAction action = (AnAction)pair.first;
            if (action == null) {
                LOG.error("Empty pair child: " + this + ", " + this.getClass() + "; index=" + i);
            } else if (action instanceof ActionStubBase) {
                if ((action = this.unStub(actionManager, (ActionStubBase)((Object)action))) == null) {
                    LOG.error("Can't unstub " + pair);
                } else {
                    this.myPairs.set(i, (Pair<AnAction, Constraints>)Pair.create((Object)action, (Object)pair.second));
                }
            }
            hasNulls |= action == null;
            children[i + sortedSize] = action;
        }
        if (hasNulls) {
            return (AnAction[])ContainerUtil.mapNotNull((Object[])children, (Function)FunctionUtil.id(), (Object[])AnAction.EMPTY_ARRAY);
        }
        return children;
    }

    @Nullable
    private AnAction unStub(@NotNull ActionManager actionManager, @NotNull ActionStubBase stub) {
        try {
            AnAction action = actionManager.getAction(stub.getId());
            if (action == null) {
                LOG.error("Null child action in group " + this + " of class " + this.getClass() + ", id=" + stub.getId());
                return null;
            }
            this.replace((AnAction)((Object)stub), action);
            return action;
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Throwable e1) {
            LOG.error(e1);
            return null;
        }
    }

    public final int getChildrenCount() {
        return this.mySortedChildren.size() + this.myPairs.size();
    }

    public final AnAction @NotNull [] getChildActionsOrStubs() {
        int i;
        int sortedSize = this.mySortedChildren.size();
        AnAction[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i = 0; i < sortedSize; ++i) {
            children[i] = this.mySortedChildren.get(i);
        }
        for (i = 0; i < this.myPairs.size(); ++i) {
            children[i + sortedSize] = (AnAction)this.myPairs.get((int)i).first;
        }
        return children;
    }

    public final void addAll(@NotNull ActionGroup group) {
        this.addAll(group.getChildren(null));
    }

    public final void addAll(@NotNull Collection<? extends AnAction> actionList) {
        this.addAll(actionList, ActionManager.getInstance());
    }

    public final void addAll(@NotNull Collection<? extends AnAction> actionList, @NotNull ActionManager actionManager) {
        if (actionList.isEmpty()) {
            return;
        }
        for (AnAction anAction : actionList) {
            this.addAction(anAction, Constraints.LAST, actionManager);
        }
    }

    public final void addAll(AnAction ... actions) {
        if (actions.length == 0) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        for (AnAction action : actions) {
            this.addAction(action, Constraints.LAST, actionManager);
        }
    }

    public void addSeparator(@Nullable @NlsContexts.Separator String separatorText) {
        this.add(Separator.create(separatorText));
    }

    public static DefaultActionGroup createUserDataAwareGroup(final String templateText) {
        return new DefaultActionGroup(){

            @Override
            @Nullable
            public String getTemplateText() {
                return templateText;
            }
        };
    }
}

