/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.ValueKey;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataKey<T>
implements ValueKey<T> {
    private static final ConcurrentMap<String, DataKey> ourDataKeyIndex = new ConcurrentHashMap<String, DataKey>();
    private final String myName;

    private DataKey(@NotNull String name) {
        this.myName = name;
    }

    @NotNull
    public static <T> DataKey<T> create(@NotNull @NonNls String name) {
        return ourDataKeyIndex.computeIfAbsent(name, DataKey::new);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public final boolean is(String dataId) {
        return this.myName.equals(dataId);
    }

    @Nullable
    public T getData(@NotNull DataContext dataContext) {
        return (T)dataContext.getData(this.myName);
    }

    @Nullable
    public T getData(@NotNull DataProvider dataProvider) {
        return (T)dataProvider.getData(this.myName);
    }
}

