/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataContextWrapper
implements DataContext,
UserDataHolder {
    private final DataContext myDelegate;
    private final UserDataHolder myDataHolder;

    public DataContextWrapper(@NotNull DataContext delegate) {
        this.myDelegate = delegate;
        this.myDataHolder = delegate instanceof UserDataHolder ? (UserDataHolder)delegate : new UserDataHolderBase();
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        return this.myDelegate.getData(dataId);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myDataHolder.putUserData(key, value);
    }
}

