/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartFMap;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionStub
extends AnAction
implements ActionStubBase {
    private static final Logger LOG = Logger.getInstance(ActionStub.class);
    private final String myClassName;
    private final String myProjectType;
    private final Supplier<Presentation> myTemplatePresentation;
    private final String myId;
    private final PluginDescriptor myPlugin;
    private final String myIconPath;
    private SmartFMap<String, Supplier<String>> myActionTextOverrides = SmartFMap.emptyMap();

    public ActionStub(@NotNull String actionClass, @NotNull String id, @NotNull PluginDescriptor plugin, @Nullable String iconPath, @Nullable String projectType, @NotNull Supplier<Presentation> templatePresentation) {
        this.myPlugin = plugin;
        this.myClassName = actionClass;
        this.myProjectType = projectType;
        this.myTemplatePresentation = templatePresentation;
        LOG.assertTrue(!id.isEmpty());
        this.myId = id;
        this.myIconPath = iconPath;
    }

    public void addActionTextOverride(@NotNull String place, @NotNull Supplier<String> text) {
        this.myActionTextOverrides = this.myActionTextOverrides.plus((Object)place, text);
    }

    public void copyActionTextOverride(@NotNull String fromPlace, @NotNull String toPlace) {
        this.myActionTextOverrides = this.myActionTextOverrides.plus((Object)toPlace, this.myActionTextOverrides.get((Object)fromPlace));
    }

    @Override
    @NotNull
    public PluginDescriptor getPlugin() {
        return this.myPlugin;
    }

    @Override
    @NotNull
    Presentation createTemplatePresentation() {
        return this.myTemplatePresentation.get();
    }

    @NotNull
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    @NotNull
    public String getId() {
        return this.myId;
    }

    public ClassLoader getLoader() {
        return this.myPlugin.getPluginClassLoader();
    }

    @Override
    public String getIconPath() {
        return this.myIconPath;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    public final void initAction(@NotNull AnAction targetAction) {
        ActionStub.copyTemplatePresentation(this.getTemplatePresentation(), targetAction.getTemplatePresentation());
        targetAction.setShortcutSet(this.getShortcutSet());
        for (String place : this.myActionTextOverrides.keySet()) {
            targetAction.addTextOverride(place, (Supplier)Objects.requireNonNull(this.myActionTextOverrides.get((Object)place)));
        }
    }

    public static void copyTemplatePresentation(Presentation sourcePresentation, Presentation targetPresentation) {
        if (targetPresentation.getIcon() == null && sourcePresentation.getIcon() != null) {
            targetPresentation.setIcon(sourcePresentation.getIcon());
        }
        if (StringUtil.isEmpty((String)targetPresentation.getText()) && sourcePresentation.getText() != null) {
            targetPresentation.setTextWithMnemonic(sourcePresentation.getTextWithPossibleMnemonic());
        }
        if (targetPresentation.getDescription() == null && sourcePresentation.getDescription() != null) {
            targetPresentation.setDescription(sourcePresentation.getDescription());
        }
    }

    public String getProjectType() {
        return this.myProjectType;
    }
}

