/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.ReflectionUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionGroup
extends AnAction {
    private boolean myPopup;
    private final PropertyChangeSupport myChangeSupport = new PropertyChangeSupport(this);
    public static final ActionGroup EMPTY_GROUP = new ActionGroup(){

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return EMPTY_ARRAY;
        }
    };
    private Set<AnAction> mySecondaryActions;
    @NonNls
    private static final String PROP_POPUP = "popup";
    private Boolean myDumbAware;

    public ActionGroup() {
    }

    public ActionGroup(@NlsActions.ActionText String shortName, boolean popup) {
        this(() -> shortName, popup);
    }

    public ActionGroup(@NotNull Supplier<@NlsActions.ActionText String> shortName, boolean popup) {
        super(shortName);
        this.setPopup(popup);
    }

    public ActionGroup(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, Icon icon) {
        super(text, description, icon);
    }

    public ActionGroup(@NotNull Supplier<@NlsActions.ActionText String> dynamicText, @NotNull Supplier<@NlsActions.ActionDescription String> dynamicDescription, Icon icon) {
        super(dynamicText, dynamicDescription, icon);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
    }

    public boolean canBePerformed(@NotNull DataContext context) {
        return false;
    }

    public boolean isPopup() {
        return this.myPopup;
    }

    public boolean isPopup(@NotNull String place) {
        return this.isPopup();
    }

    public final void setPopup(boolean popup) {
        boolean oldPopup = this.myPopup;
        this.myPopup = popup;
        this.firePropertyChange(PROP_POPUP, oldPopup, this.myPopup);
    }

    public final void addPropertyChangeListener(@NotNull PropertyChangeListener l) {
        this.myChangeSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(@NotNull PropertyChangeListener l) {
        this.myChangeSupport.removePropertyChangeListener(l);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.myChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public abstract AnAction @NotNull [] getChildren(@Nullable AnActionEvent var1);

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e, @NotNull ActionManager actionManager) {
        return this.getChildren(null);
    }

    final void setAsPrimary(@NotNull AnAction action, boolean isPrimary) {
        if (isPrimary) {
            if (this.mySecondaryActions != null) {
                this.mySecondaryActions.remove(action);
            }
        } else {
            if (this.mySecondaryActions == null) {
                this.mySecondaryActions = new HashSet<AnAction>();
            }
            this.mySecondaryActions.add(action);
        }
    }

    public final boolean isPrimary(@NotNull AnAction action) {
        return this.mySecondaryActions == null || !this.mySecondaryActions.contains(action);
    }

    protected final void replace(@NotNull AnAction originalAction, @NotNull AnAction newAction) {
        if (this.mySecondaryActions != null && this.mySecondaryActions.contains(originalAction)) {
            this.mySecondaryActions.remove(originalAction);
            this.mySecondaryActions.add(newAction);
        }
    }

    @Override
    public boolean isDumbAware() {
        if (this.myDumbAware != null) {
            return this.myDumbAware;
        }
        boolean dumbAware = super.isDumbAware();
        if (dumbAware) {
            this.myDumbAware = Boolean.TRUE;
        } else if (this.myDumbAware == null) {
            Class declaringClass = ReflectionUtil.getMethodDeclaringClass(this.getClass(), (String)"update", (Class[])new Class[]{AnActionEvent.class});
            this.myDumbAware = AnAction.class.equals((Object)declaringClass) || ActionGroup.class.equals((Object)declaringClass);
        }
        return this.myDumbAware;
    }

    public boolean hideIfNoVisibleChildren() {
        return false;
    }

    public boolean disableIfNoVisibleChildren() {
        return true;
    }
}

