/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsContexts;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NotificationAction
extends DumbAwareAction {
    public NotificationAction(@Nullable @NlsContexts.NotificationContent String text) {
        super(text);
    }

    public NotificationAction(@NotNull Supplier<String> dynamicText) {
        super(dynamicText);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        this.actionPerformed(e, Notification.get(e));
    }

    public abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull Notification var2);

    @NotNull
    public static NotificationAction create(@NotNull @NlsContexts.NotificationContent String text, @NotNull BiConsumer<? super AnActionEvent, ? super Notification> performAction) {
        return NotificationAction.create(() -> text, performAction);
    }

    @NotNull
    public static NotificationAction create(@NotNull Supplier<String> dynamicText, @NotNull BiConsumer<? super AnActionEvent, ? super Notification> performAction) {
        return new Simple(dynamicText, performAction, performAction);
    }

    @NotNull
    public static NotificationAction createSimple(@NotNull Supplier<String> dynamicText, @NotNull Runnable performAction) {
        return new Simple(dynamicText, (event, notification) -> performAction.run(), performAction);
    }

    @NotNull
    public static NotificationAction createSimple(@NotNull @NlsContexts.NotificationContent String text, @NotNull Runnable performAction) {
        return new Simple(() -> text, (event, notification) -> performAction.run(), performAction);
    }

    @NotNull
    public static NotificationAction createSimpleExpiring(@NotNull @NlsContexts.NotificationContent String text, @NotNull Runnable performAction) {
        return new Simple(() -> text, (event, notification) -> {
            performAction.run();
            notification.expire();
        }, performAction);
    }

    public static class Simple
    extends NotificationAction {
        @NotNull
        private final BiConsumer<? super AnActionEvent, ? super Notification> myPerformAction;
        @NotNull
        private final Object myActionInstance;

        public Simple(@NotNull Supplier<String> dynamicText, @NotNull BiConsumer<? super AnActionEvent, ? super Notification> performAction, @NotNull Object actionInstance) {
            super(dynamicText);
            this.myPerformAction = performAction;
            this.myActionInstance = actionInstance;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            this.myPerformAction.accept(e, notification);
        }

        public Object getActionInstance() {
            return this.myActionInstance;
        }
    }
}

