/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.ide.DataManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Notification {
    private static final Logger LOG = Logger.getInstance(Notification.class);
    private static final DataKey<Notification> KEY = DataKey.create("Notification");
    public final String id;
    @Nullable
    public final String displayId;
    private final String myGroupId;
    private Icon myIcon;
    private final NotificationType myType;
    private String myTitle;
    private String mySubtitle;
    private String myContent;
    private NotificationListener myListener;
    private String myDropDownText;
    private List<AnAction> myActions;
    private CollapseActionsDirection myCollapseActionsDirection = CollapseActionsDirection.KEEP_RIGHTMOST;
    private AnAction myContextHelpAction;
    private final AtomicBoolean myExpired = new AtomicBoolean(false);
    private Runnable myWhenExpired;
    private Boolean myImportant;
    private WeakReference<Balloon> myBalloonRef;
    private final long myTimestamp;

    public Notification(@NotNull String groupId, @Nullable Icon icon, @NotNull NotificationType type) {
        this(groupId, icon, null, null, null, type, null);
    }

    public Notification(@NotNull @NonNls String groupId, @Nullable Icon icon, @Nullable @NlsContexts.NotificationTitle String title, @Nullable @NlsContexts.NotificationSubtitle String subtitle, @Nullable @NlsContexts.NotificationContent String content, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        this.myGroupId = groupId;
        this.myTitle = StringUtil.notNullize((String)title);
        this.myContent = StringUtil.notNullize((String)content);
        this.myType = type;
        this.myListener = listener2;
        this.myTimestamp = System.currentTimeMillis();
        this.myIcon = icon;
        this.mySubtitle = subtitle;
        this.displayId = null;
        this.id = Notification.calculateId(this);
    }

    public Notification(@NotNull @NonNls String groupId, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type) {
        this(groupId, null, title, content, type, null);
    }

    public Notification(@NotNull @NonNls String groupId, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        this(groupId, null, title, content, type, listener2);
    }

    public Notification(@NotNull @NonNls String groupId, @Nullable @NonNls String displayId, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        this.myGroupId = groupId;
        this.myTitle = title;
        this.myContent = content;
        this.myType = type;
        this.myListener = listener2;
        this.myTimestamp = System.currentTimeMillis();
        this.displayId = displayId;
        this.id = Notification.calculateId(this);
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public Notification setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
        return this;
    }

    @NotNull
    public String getGroupId() {
        return this.myGroupId;
    }

    public boolean hasTitle() {
        return !StringUtil.isEmptyOrSpaces((String)this.myTitle) || !StringUtil.isEmptyOrSpaces((String)this.mySubtitle);
    }

    @NotNull
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public Notification setTitle(@Nullable @NlsContexts.NotificationTitle String title) {
        this.myTitle = StringUtil.notNullize((String)title);
        return this;
    }

    @NotNull
    public Notification setTitle(@Nullable @NlsContexts.NotificationTitle String title, @Nullable @NlsContexts.NotificationSubtitle String subtitle) {
        return this.setTitle(title).setSubtitle(subtitle);
    }

    @Nullable
    public String getSubtitle() {
        return this.mySubtitle;
    }

    @NotNull
    public Notification setSubtitle(@Nullable String subtitle) {
        this.mySubtitle = subtitle;
        return this;
    }

    public boolean hasContent() {
        return !StringUtil.isEmptyOrSpaces((String)this.myContent);
    }

    @NotNull
    public String getContent() {
        return this.myContent;
    }

    @NotNull
    public Notification setContent(@Nullable String content) {
        this.myContent = StringUtil.notNullize((String)content);
        return this;
    }

    @Nullable
    public NotificationListener getListener() {
        return this.myListener;
    }

    @NotNull
    public Notification setListener(@NotNull NotificationListener listener2) {
        this.myListener = listener2;
        return this;
    }

    @NotNull
    public List<AnAction> getActions() {
        return ContainerUtil.notNullize(this.myActions);
    }

    @NotNull
    public static Notification get(@NotNull AnActionEvent e) {
        return e.getData(KEY);
    }

    public static void fire(@NotNull Notification notification, @NotNull AnAction action) {
        Notification.fire(notification, action, null);
    }

    public static void fire(@NotNull Notification notification, @NotNull AnAction action, @Nullable DataContext context) {
        AnActionEvent event = AnActionEvent.createFromAnAction(action, null, "Notification", dataId -> {
            if (KEY.is(dataId)) {
                return notification;
            }
            return context == null ? null : context.getData(dataId);
        });
        if (ActionUtil.lastUpdateAndCheckDumb(action, event, false)) {
            ActionUtil.performActionDumbAwareWithCallbacks(action, event, event.getDataContext());
        }
    }

    public static void setDataProvider(@NotNull Notification notification, @NotNull JComponent component) {
        DataManager.registerDataProvider(component, dataId -> KEY.getName().equals(dataId) ? notification : null);
    }

    @NotNull
    public String getDropDownText() {
        if (this.myDropDownText == null) {
            this.myDropDownText = "Actions";
        }
        return this.myDropDownText;
    }

    @NotNull
    public Notification setDropDownText(@NotNull @NlsContexts.LinkLabel String dropDownText) {
        this.myDropDownText = dropDownText;
        return this;
    }

    public CollapseActionsDirection getCollapseActionsDirection() {
        return this.myCollapseActionsDirection;
    }

    public void setCollapseActionsDirection(CollapseActionsDirection collapseActionsDirection) {
        this.myCollapseActionsDirection = collapseActionsDirection;
    }

    @NotNull
    public Notification addAction(@NotNull AnAction action) {
        if (this.myActions == null) {
            this.myActions = new ArrayList<AnAction>();
        }
        this.myActions.add(action);
        return this;
    }

    public Notification setContextHelpAction(AnAction action) {
        this.myContextHelpAction = action;
        return this;
    }

    public AnAction getContextHelpAction() {
        return this.myContextHelpAction;
    }

    @NotNull
    public NotificationType getType() {
        return this.myType;
    }

    public boolean isExpired() {
        return this.myExpired.get();
    }

    public void expire() {
        if (!this.myExpired.compareAndSet(false, true)) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(this::hideBalloon);
        NotificationsManager.getNotificationsManager().expire(this);
        Runnable whenExpired = this.myWhenExpired;
        if (whenExpired != null) {
            whenExpired.run();
        }
    }

    public Notification whenExpired(@Nullable Runnable whenExpired) {
        this.myWhenExpired = whenExpired;
        return this;
    }

    public void hideBalloon() {
        if (this.myBalloonRef != null) {
            Balloon balloon = (Balloon)this.myBalloonRef.get();
            if (balloon != null) {
                balloon.hide();
            }
            this.myBalloonRef = null;
        }
    }

    public void setBalloon(final @NotNull Balloon balloon) {
        this.hideBalloon();
        this.myBalloonRef = new WeakReference<Balloon>(balloon);
        balloon.addListener(new JBPopupListener(){

            @Override
            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (SoftReference.dereference((Reference)Notification.this.myBalloonRef) == balloon) {
                    Notification.this.myBalloonRef = null;
                }
            }
        });
    }

    @Nullable
    public Balloon getBalloon() {
        return (Balloon)SoftReference.dereference(this.myBalloonRef);
    }

    public void notify(@Nullable Project project) {
        Notifications.Bus.notify(this, project);
    }

    public Notification setImportant(boolean important) {
        this.myImportant = important;
        return this;
    }

    public boolean isImportant() {
        if (this.myImportant != null) {
            return this.myImportant;
        }
        return this.getListener() != null || !ContainerUtil.isEmpty(this.myActions);
    }

    @NotNull
    private static String calculateId(@NotNull Object notification) {
        return System.currentTimeMillis() + "." + System.identityHashCode(notification);
    }

    public final void assertHasTitleOrContent() {
        LOG.assertTrue(this.hasTitle() || this.hasContent(), (Object)("Notification should have title and/or content; groupId: " + this.myGroupId));
    }

    public String toString() {
        return String.format("Notification{id='%s', myGroupId='%s', myType=%s, myTitle='%s', mySubtitle='%s', myContent='%s'}", new Object[]{this.id, this.myGroupId, this.myType, this.myTitle, this.mySubtitle, this.myContent});
    }

    public static enum CollapseActionsDirection {
        KEEP_LEFTMOST,
        KEEP_RIGHTMOST;

    }
}

