/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.PsiNavigateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoRelatedItem {
    private final String myGroup;
    private final int myMnemonic;
    @Nullable
    private final SmartPsiElementPointer<PsiElement> myElementPointer;
    public static final String DEFAULT_GROUP_NAME = "";

    protected GotoRelatedItem(@Nullable PsiElement element, String group, int mnemonic) {
        this.myElementPointer = element == null ? null : SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
        this.myGroup = group;
        this.myMnemonic = mnemonic;
    }

    public GotoRelatedItem(@NotNull PsiElement element, String group) {
        this(element, group, -1);
    }

    public GotoRelatedItem(@NotNull PsiElement element) {
        this(element, DEFAULT_GROUP_NAME);
    }

    public void navigate() {
        PsiElement element = this.getElement();
        if (element != null) {
            PsiNavigateUtil.navigate(element);
        }
    }

    @Nullable
    public String getCustomName() {
        return null;
    }

    @Nullable
    public String getCustomContainerName() {
        return null;
    }

    @Nullable
    public Icon getCustomIcon() {
        return null;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElementPointer == null ? null : this.myElementPointer.getElement();
    }

    public int getMnemonic() {
        return this.myMnemonic;
    }

    public static List<GotoRelatedItem> createItems(@NotNull Collection<? extends PsiElement> elements) {
        return GotoRelatedItem.createItems(elements, DEFAULT_GROUP_NAME);
    }

    public static List<GotoRelatedItem> createItems(@NotNull Collection<? extends PsiElement> elements, String group) {
        ArrayList<GotoRelatedItem> items = new ArrayList<GotoRelatedItem>(elements.size());
        for (PsiElement psiElement : elements) {
            items.add(new GotoRelatedItem(psiElement, group));
        }
        return items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GotoRelatedItem item = (GotoRelatedItem)o;
        return !(this.myElementPointer != null ? !this.myElementPointer.equals(item.myElementPointer) : item.myElementPointer != null);
    }

    public String getGroup() {
        return this.myGroup;
    }

    public int hashCode() {
        return this.myElementPointer != null ? this.myElementPointer.hashCode() : 0;
    }
}

