/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.presentation;

import com.intellij.model.presentation.SymbolPresentationImpl;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SymbolPresentation {
    @Nullable
    default public Icon getIcon() {
        return null;
    }

    @Nls
    @NotNull
    public String getShortNameString();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getShortDescription();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    default public String getLongDescription() {
        return this.getShortDescription();
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static SymbolPresentation create(@Nls @NotNull String shortNameString, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String shortDescription) {
        return SymbolPresentation.create(null, shortNameString, shortDescription, shortDescription);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static SymbolPresentation create(@Nullable Icon icon, @Nls @NotNull String shortNameString, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String shortDescription) {
        return SymbolPresentation.create(icon, shortNameString, shortDescription, shortDescription);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static SymbolPresentation create(@Nullable Icon icon, @Nls @NotNull String shortNameString, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String shortDescription, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String longDescription) {
        return new SymbolPresentationImpl(icon, shortNameString, shortDescription, longDescription);
    }
}

