/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.model.BranchService;
import com.intellij.model.BranchedVirtualFile;
import com.intellij.model.ModelPatch;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface ModelBranch {
    @NotNull
    public static ModelPatch performInBranch(@NotNull Project project, @NotNull Consumer<ModelBranch> action) {
        return BranchService.getInstance().performInBranch(project, action);
    }

    @Nullable
    public VirtualFile findFileCopy(@NotNull VirtualFile var1);

    @Nullable
    public <T extends PsiElement> T findPsiCopy(@NotNull T var1);

    @Nullable
    public <T extends PsiSymbolReference> T findReferenceCopy(@NotNull T var1);

    @NotNull
    public <T extends PsiElement> T obtainPsiCopy(@NotNull T var1);

    @Nullable
    public <T extends PsiElement> T findOriginalPsi(@NotNull T var1);

    @Nullable
    public VirtualFile findOriginalFile(@NotNull VirtualFile var1);

    @Nullable
    public static ModelBranch getPsiBranch(@NotNull PsiElement element) {
        return ModelBranch.getFileBranch(element.getContainingFile().getViewProvider().getVirtualFile());
    }

    @Nullable
    public static ModelBranch getFileBranch(@NotNull VirtualFile file) {
        return file instanceof BranchedVirtualFile ? ((BranchedVirtualFile)file).branch : null;
    }

    public long getBranchedPsiModificationCount();

    public void runAfterMerge(@NotNull Runnable var1);
}

