/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CustomFoldingProvider {
    public static final ExtensionPointName<CustomFoldingProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.customFoldingProvider");
    private static final Logger LOG = Logger.getInstance(CustomFoldingProvider.class);

    @NotNull
    public static List<CustomFoldingProvider> getAllProviders() {
        return EP_NAME.getExtensionList();
    }

    public abstract boolean isCustomRegionStart(String var1);

    public abstract boolean isCustomRegionEnd(String var1);

    public abstract String getPlaceholderText(String var1);

    @Nls(capitalization=Nls.Capitalization.Sentence)
    public abstract String getDescription();

    public boolean wrapStartEndMarkerTextInLanguageSpecificComment() {
        return true;
    }

    public boolean isSupportedBy(FoldingBuilder foldingBuilder) {
        if (!this.wrapStartEndMarkerTextInLanguageSpecificComment()) {
            LOG.error("non-comment based custom folding node need to be filtered in overridden `CustomFoldingBuilder#isCustomFoldingCandidate(ASTNode)`");
        }
        return foldingBuilder instanceof CustomFoldingBuilder;
    }

    @NonNls
    public abstract String getStartString();

    @NonNls
    public abstract String getEndString();

    public boolean isCollapsedByDefault(String text) {
        return CodeFoldingSettings.getInstance().COLLAPSE_CUSTOM_FOLDING_REGIONS;
    }
}

