/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.annotation;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Annotation
implements Segment {
    private final int myStartOffset;
    private final int myEndOffset;
    private final HighlightSeverity mySeverity;
    private final String myMessage;
    private ProblemHighlightType myHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    private TextAttributesKey myEnforcedAttributesKey;
    private TextAttributes myEnforcedAttributes;
    private List<QuickFixInfo> myQuickFixes;
    private Boolean myNeedsUpdateOnTyping;
    private String myTooltip;
    private boolean myAfterEndOfLine;
    private boolean myIsFileLevelAnnotation;
    private GutterIconRenderer myGutterIconRenderer;
    @Nullable
    private ProblemGroup myProblemGroup;
    private List<QuickFixInfo> myBatchFixes;

    @ApiStatus.Internal
    public Annotation(int startOffset, int endOffset, @NotNull HighlightSeverity severity, String message, String tooltip) {
        assert (startOffset <= endOffset) : startOffset + ":" + endOffset;
        assert (startOffset >= 0) : "Start offset must not be negative: " + startOffset;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myMessage = message;
        this.myTooltip = tooltip;
        this.mySeverity = severity;
    }

    public void registerFix(@NotNull IntentionAction fix2) {
        this.registerFix(fix2, null);
    }

    public void registerFix(@NotNull IntentionAction fix2, TextRange range) {
        this.registerFix(fix2, range, null);
    }

    public void registerFix(@NotNull LocalQuickFix fix2, @Nullable TextRange range, @Nullable HighlightDisplayKey key, @NotNull ProblemDescriptor problemDescriptor) {
        range = this.notNullize(range);
        if (this.myQuickFixes == null) {
            this.myQuickFixes = new ArrayList<QuickFixInfo>();
        }
        this.myQuickFixes.add(new QuickFixInfo(new LocalQuickFixAsIntentionAdapter(fix2, problemDescriptor), range, key));
    }

    public void registerFix(@NotNull IntentionAction fix2, @Nullable TextRange range, @Nullable HighlightDisplayKey key) {
        range = this.notNullize(range);
        List<QuickFixInfo> fixes = this.myQuickFixes;
        if (fixes == null) {
            this.myQuickFixes = fixes = new ArrayList<QuickFixInfo>();
        }
        fixes.add(new QuickFixInfo(fix2, range, key));
    }

    @NotNull
    private TextRange notNullize(@Nullable TextRange range) {
        return range == null ? new TextRange(this.myStartOffset, this.myEndOffset) : range;
    }

    public <T extends IntentionAction & LocalQuickFix> void registerBatchFix(@NotNull T fix2, @Nullable TextRange range, @Nullable HighlightDisplayKey key) {
        range = this.notNullize(range);
        List<QuickFixInfo> fixes = this.myBatchFixes;
        if (fixes == null) {
            this.myBatchFixes = fixes = new ArrayList<QuickFixInfo>();
        }
        fixes.add(new QuickFixInfo(fix2, range, key));
    }

    public <T extends IntentionAction & LocalQuickFix> void registerUniversalFix(@NotNull T fix2, @Nullable TextRange range, @Nullable HighlightDisplayKey key) {
        this.registerBatchFix(fix2, range, key);
        this.registerFix(fix2, range, key);
    }

    public void setNeedsUpdateOnTyping(boolean b) {
        this.myNeedsUpdateOnTyping = b;
    }

    public boolean needsUpdateOnTyping() {
        if (this.myNeedsUpdateOnTyping == null) {
            return this.mySeverity != HighlightSeverity.INFORMATION;
        }
        return this.myNeedsUpdateOnTyping;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        return this.mySeverity;
    }

    @NotNull
    public ProblemHighlightType getHighlightType() {
        return this.myHighlightType;
    }

    @NotNull
    public TextAttributesKey getTextAttributes() {
        if (this.myEnforcedAttributesKey != null) {
            return this.myEnforcedAttributesKey;
        }
        switch (this.myHighlightType) {
            case GENERIC_ERROR_OR_WARNING: {
                if (this.mySeverity == HighlightSeverity.ERROR) {
                    return CodeInsightColors.ERRORS_ATTRIBUTES;
                }
                if (this.mySeverity == HighlightSeverity.WARNING) {
                    return CodeInsightColors.WARNINGS_ATTRIBUTES;
                }
                if (this.mySeverity == HighlightSeverity.WEAK_WARNING) {
                    return CodeInsightColors.WEAK_WARNING_ATTRIBUTES;
                }
                return HighlighterColors.NO_HIGHLIGHTING;
            }
            case GENERIC_ERROR: {
                return CodeInsightColors.ERRORS_ATTRIBUTES;
            }
            case LIKE_DEPRECATED: {
                return CodeInsightColors.DEPRECATED_ATTRIBUTES;
            }
            case LIKE_UNUSED_SYMBOL: {
                return CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
            }
            case LIKE_UNKNOWN_SYMBOL: 
            case ERROR: {
                return CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES;
            }
        }
        return HighlighterColors.NO_HIGHLIGHTING;
    }

    public TextAttributes getEnforcedTextAttributes() {
        return this.myEnforcedAttributes;
    }

    public void setEnforcedTextAttributes(TextAttributes enforcedAttributes) {
        this.myEnforcedAttributes = enforcedAttributes;
    }

    @Nullable
    public List<QuickFixInfo> getQuickFixes() {
        return this.myQuickFixes;
    }

    @Nullable
    public List<QuickFixInfo> getBatchFixes() {
        return this.myBatchFixes;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public String getTooltip() {
        return this.myTooltip;
    }

    public void setTooltip(@NlsContexts.Tooltip String tooltip) {
        this.myTooltip = tooltip;
    }

    public void setHighlightType(@NotNull ProblemHighlightType highlightType) {
        this.myHighlightType = highlightType;
    }

    public void setTextAttributes(TextAttributesKey enforcedAttributes) {
        this.myEnforcedAttributesKey = enforcedAttributes;
    }

    public boolean isAfterEndOfLine() {
        return this.myAfterEndOfLine;
    }

    public void setAfterEndOfLine(boolean afterEndOfLine) {
        this.myAfterEndOfLine = afterEndOfLine;
    }

    public boolean isFileLevelAnnotation() {
        return this.myIsFileLevelAnnotation;
    }

    public void setFileLevelAnnotation(boolean isFileLevelAnnotation) {
        this.myIsFileLevelAnnotation = isFileLevelAnnotation;
    }

    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    public void setGutterIconRenderer(@Nullable GutterIconRenderer gutterIconRenderer) {
        this.myGutterIconRenderer = gutterIconRenderer;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
        this.myProblemGroup = problemGroup;
    }

    @NonNls
    public String toString() {
        return "Annotation(message='" + this.myMessage + "', severity='" + this.mySeverity + "', toolTip='" + this.myTooltip + "')";
    }

    public static class QuickFixInfo {
        @NotNull
        public final IntentionAction quickFix;
        @NotNull
        public final TextRange textRange;
        public final HighlightDisplayKey key;

        QuickFixInfo(@NotNull IntentionAction fix2, @NotNull TextRange range, @Nullable HighlightDisplayKey key) {
            this.key = key;
            this.quickFix = fix2;
            this.textRange = range;
        }

        public String toString() {
            return this.quickFix.toString();
        }
    }
}

