/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class TreeBuilderUtil {
    private static final Logger LOG = Logger.getInstance(TreeBuilderUtil.class);

    public static void storePaths(@NotNull AbstractTreeBuilder treeBuilder, @NotNull DefaultMutableTreeNode root, @NotNull List<Object> pathsToExpand, @NotNull List<Object> selectionPaths, boolean storeElementsOnly) {
        if (!treeBuilder.wasRootNodeInitialized()) {
            return;
        }
        JTree tree = treeBuilder.getTree();
        if (tree != null) {
            TreeBuilderUtil.storePaths(tree, root, pathsToExpand, selectionPaths, storeElementsOnly);
        }
    }

    public static void storePaths(@NotNull JTree tree, @NotNull DefaultMutableTreeNode root, @NotNull List<Object> pathsToExpand, @NotNull List<Object> selectionPaths, boolean storeElementsOnly) {
        TreePath path2 = new TreePath(root.getPath());
        if (tree.isPathSelected(path2)) {
            selectionPaths.add(storeElementsOnly ? ((NodeDescriptor)root.getUserObject()).getElement() : path2);
        }
        if (tree.isExpanded(path2) || root.getChildCount() == 0) {
            pathsToExpand.add(storeElementsOnly ? ((NodeDescriptor)root.getUserObject()).getElement() : path2);
            TreeBuilderUtil._storePaths(tree, root, pathsToExpand, selectionPaths, storeElementsOnly);
        }
    }

    private static void _storePaths(@NotNull JTree tree, @NotNull DefaultMutableTreeNode root, @NotNull List<Object> pathsToExpand, @NotNull List<Object> selectionPaths, boolean storeElementsOnly) {
        List<TreeNode> childNodes = TreeUtil.listChildren(root);
        for (TreeNode childNode1 : childNodes) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)childNode1;
            TreePath path2 = new TreePath(childNode.getPath());
            Object userObject = childNode.getUserObject();
            if (tree.isPathSelected(path2)) {
                if (!(userObject instanceof NodeDescriptor)) {
                    LOG.error("Node: " + childNode + "; userObject: " + userObject + " of class " + userObject.getClass());
                    return;
                }
                selectionPaths.add(storeElementsOnly ? ((NodeDescriptor)userObject).getElement() : path2);
            }
            if (!tree.isExpanded(path2) && childNode.getChildCount() != 0) continue;
            pathsToExpand.add(storeElementsOnly && userObject instanceof NodeDescriptor ? ((NodeDescriptor)userObject).getElement() : path2);
            TreeBuilderUtil._storePaths(tree, childNode, pathsToExpand, selectionPaths, storeElementsOnly);
        }
    }

    public static void restorePaths(@NotNull AbstractTreeBuilder treeBuilder, @NotNull List<Object> pathsToExpand, @NotNull List<Object> selectionPaths, boolean elementsOnly) {
        JTree tree = treeBuilder.getTree();
        if (!elementsOnly) {
            for (Object path2 : pathsToExpand) {
                tree.expandPath((TreePath)path2);
            }
            tree.addSelectionPaths(selectionPaths.toArray(TreeUtil.EMPTY_TREE_PATH));
        } else {
            DefaultMutableTreeNode node;
            for (Object element : pathsToExpand) {
                treeBuilder.buildNodeForElement(element);
                node = treeBuilder.getNodeForElement(element);
                if (node == null) continue;
                tree.expandPath(new TreePath(node.getPath()));
            }
            for (Object element : selectionPaths) {
                node = treeBuilder.getNodeForElement(element);
                if (node == null) continue;
                DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                tree.addSelectionPath(new TreePath(treeModel.getPathToRoot(node)));
            }
        }
    }

    static boolean isNodeOrChildSelected(@NotNull JTree tree, @NotNull DefaultMutableTreeNode node) {
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return false;
        }
        TreePath path2 = new TreePath(node.getPath());
        for (TreePath selectionPath : selectionPaths) {
            if (!path2.isDescendant(selectionPath)) continue;
            return true;
        }
        return false;
    }
}

