/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeAnchorizer {
    private static final TreeAnchorizer ourInstance;

    public static TreeAnchorizer getService() {
        return ourInstance;
    }

    @NotNull
    public Object createAnchor(@NotNull Object element) {
        return element;
    }

    @Nullable
    public Object retrieveElement(@NotNull Object anchor) {
        return anchor;
    }

    public void freeAnchor(Object element) {
    }

    @NotNull
    public static List<Object> anchorizeList(@NotNull Collection<Object> elements) {
        return ContainerUtil.map(elements, TreeAnchorizer.getService()::createAnchor);
    }

    @NotNull
    public static List<Object> retrieveList(Collection<Object> anchors) {
        return ContainerUtil.mapNotNull(anchors, TreeAnchorizer.getService()::retrieveElement);
    }

    static {
        TreeAnchorizer implementation = ServiceManager.getService(TreeAnchorizer.class);
        ourInstance = implementation == null ? new TreeAnchorizer() : implementation;
    }
}

