/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeDescriptor<E> {
    public static final NodeDescriptor<?>[] EMPTY_ARRAY = new NodeDescriptor[0];
    public static final int DEFAULT_WEIGHT = 30;
    protected final Project myProject;
    private final NodeDescriptor<?> myParentDescriptor;
    protected String myName;
    @Nullable
    protected Icon myClosedIcon;
    @Deprecated
    protected Icon myOpenIcon;
    protected Color myColor;
    private int myIndex = -1;
    private long myChildrenSortingStamp = -1L;
    private long myUpdateCount;
    private boolean myWasDeclaredAlwaysLeaf;

    public NodeDescriptor(@Nullable Project project, @Nullable NodeDescriptor<?> parentDescriptor) {
        this.myProject = project;
        this.myParentDescriptor = parentDescriptor;
    }

    @Nullable
    public NodeDescriptor<?> getParentDescriptor() {
        return this.myParentDescriptor;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public void setIndex(int index) {
        this.myIndex = index;
    }

    public abstract boolean update();

    public abstract E getElement();

    public String toString() {
        return this.myName;
    }

    @Deprecated
    public final Icon getOpenIcon() {
        return this.getIcon();
    }

    @Deprecated
    public final Icon getClosedIcon() {
        return this.getIcon();
    }

    @Nullable
    public final Icon getIcon() {
        return this.myClosedIcon;
    }

    public final Color getColor() {
        return this.myColor;
    }

    @Nullable
    public final Project getProject() {
        return this.myProject;
    }

    public boolean expandOnDoubleClick() {
        return true;
    }

    public int getWeight() {
        E element = this.getElement();
        if (element instanceof WeighedItem) {
            return ((WeighedItem)element).getWeight();
        }
        return 30;
    }

    public final long getChildrenSortingStamp() {
        return this.myChildrenSortingStamp;
    }

    public final void setChildrenSortingStamp(long stamp) {
        this.myChildrenSortingStamp = stamp;
    }

    public final long getUpdateCount() {
        return this.myUpdateCount;
    }

    public final void setUpdateCount(long updateCount) {
        this.myUpdateCount = updateCount;
    }

    public boolean isWasDeclaredAlwaysLeaf() {
        return this.myWasDeclaredAlwaysLeaf;
    }

    public void setWasDeclaredAlwaysLeaf(boolean leaf) {
        this.myWasDeclaredAlwaysLeaf = leaf;
    }

    public void applyFrom(@NotNull NodeDescriptor<?> desc) {
        this.setIcon(desc.getIcon());
        this.myName = desc.myName;
        this.myColor = desc.myColor;
    }

    public void setIcon(@Nullable Icon closedIcon) {
        this.myClosedIcon = closedIcon;
    }

    public static abstract class NodeComparator<T extends NodeDescriptor<?>>
    implements Comparator<T> {
        private long myStamp;

        public final void setStamp(long stamp) {
            this.myStamp = stamp;
        }

        public long getStamp() {
            return this.myStamp;
        }

        public void incStamp() {
            this.setStamp(this.getStamp() + 1L);
        }

        public static final class Delegate<T extends NodeDescriptor<?>>
        extends NodeComparator<T> {
            @NotNull
            private NodeComparator<? super T> myDelegate;

            public Delegate(@NotNull NodeComparator<? super T> delegate) {
                this.myDelegate = delegate;
            }

            public void setDelegate(@NotNull NodeComparator<? super T> delegate) {
                this.myDelegate = delegate;
            }

            @Override
            public long getStamp() {
                return this.myDelegate.getStamp();
            }

            @Override
            public void incStamp() {
                this.myDelegate.incStamp();
            }

            @Override
            public int compare(T o1, T o2) {
                return this.myDelegate.compare(o1, o2);
            }
        }
    }
}

