/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.platform.ProjectTemplate;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WizardContext
extends UserDataHolderBase {
    @Nullable
    private final Project myProject;
    private final Disposable myDisposable;
    private Path myProjectFileDirectory;
    private String myProjectName;
    private String myCompilerOutputDirectory;
    private Sdk myProjectJdk;
    private ProjectBuilder myProjectBuilder;
    private ProjectBuilder myOriginalBuilder;
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private StorageScheme myProjectStorageFormat = StorageScheme.DIRECTORY_BASED;
    private ModulesProvider myModulesProvider;
    private boolean myProjectFileDirectorySetExplicitly;
    private AbstractWizard<?> myWizard;
    private String myDefaultModuleName = "untitled";

    public void setProjectStorageFormat(StorageScheme format) {
        this.myProjectStorageFormat = format;
    }

    @Deprecated
    public boolean isNewWizard() {
        return true;
    }

    public ModulesProvider getModulesProvider() {
        return this.myModulesProvider;
    }

    public void setModulesProvider(ModulesProvider modulesProvider) {
        this.myModulesProvider = modulesProvider;
    }

    public Disposable getDisposable() {
        return this.myDisposable;
    }

    public AbstractWizard<?> getWizard() {
        return this.myWizard;
    }

    public void setWizard(AbstractWizard<?> wizard) {
        this.myWizard = wizard;
    }

    public void setDefaultModuleName(String defaultModuleName) {
        this.myDefaultModuleName = defaultModuleName;
    }

    public String getDefaultModuleName() {
        return this.myDefaultModuleName;
    }

    public WizardContext(@Nullable Project project, Disposable parentDisposable) {
        this.myProject = project;
        this.myDisposable = parentDisposable;
        if (this.myProject != null) {
            this.myProjectJdk = ProjectRootManager.getInstance(this.myProject).getProjectSdk();
        }
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getProjectFileDirectory() {
        return this.getProjectDirectory().toString();
    }

    @NotNull
    public Path getProjectDirectory() {
        if (this.myProjectFileDirectory != null) {
            return this.myProjectFileDirectory;
        }
        String lastProjectLocation = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (lastProjectLocation != null) {
            return Paths.get(lastProjectLocation, new String[0]);
        }
        String userHome = SystemProperties.getUserHome();
        String productName = ApplicationNamesInfo.getInstance().getLowercaseProductName();
        return Paths.get(userHome, productName.replace(" ", "") + "Projects");
    }

    public boolean isProjectFileDirectorySet() {
        return this.myProjectFileDirectory != null;
    }

    public boolean isProjectFileDirectorySetExplicitly() {
        return this.myProjectFileDirectorySetExplicitly;
    }

    public void setProjectFileDirectory(@Nullable String value) {
        this.setProjectFileDirectory(value == null ? null : Paths.get(value, new String[0]), false);
    }

    public void setProjectFileDirectory(@Nullable Path projectFileDirectory, boolean explicitly) {
        this.myProjectFileDirectorySetExplicitly = explicitly;
        this.myProjectFileDirectory = projectFileDirectory == null ? null : projectFileDirectory.normalize();
    }

    public String getCompilerOutputDirectory() {
        return this.myCompilerOutputDirectory;
    }

    public void setCompilerOutputDirectory(String compilerOutputDirectory) {
        this.myCompilerOutputDirectory = compilerOutputDirectory;
    }

    public String getProjectName() {
        return this.myProjectName;
    }

    public void setProjectName(String projectName) {
        this.myProjectName = projectName;
    }

    public boolean isCreatingNewProject() {
        return this.myProject == null;
    }

    @Nullable
    public Icon getStepIcon() {
        return null;
    }

    public void requestWizardButtonsUpdate() {
        for (Listener listener2 : this.myListeners) {
            listener2.buttonsUpdateRequested();
        }
    }

    public void requestNextStep() {
        for (Listener listener2 : this.myListeners) {
            listener2.nextStepRequested();
        }
    }

    public void addContextListener(Listener listener2) {
        this.myListeners.add(listener2);
    }

    public void setProjectJdk(Sdk jdk) {
        this.myProjectJdk = jdk;
    }

    public Sdk getProjectJdk() {
        return this.myProjectJdk;
    }

    @Nullable
    public ProjectBuilder getProjectBuilder() {
        return this.myProjectBuilder;
    }

    public void setProjectBuilder(@Nullable ProjectBuilder projectBuilder) {
        this.myOriginalBuilder = this.myProjectBuilder = projectBuilder;
    }

    public void setProjectTemplate(@Nullable ProjectTemplate projectTemplate) {
        this.myProjectBuilder = projectTemplate != null ? projectTemplate.createModuleBuilder() : this.myOriginalBuilder;
    }

    public String getPresentationName() {
        return IdeBundle.message(this.myProject == null ? "project.new.wizard.project.identification" : "project.new.wizard.module.identification", new Object[0]);
    }

    public StorageScheme getProjectStorageFormat() {
        return this.myProjectStorageFormat;
    }

    public static interface Listener {
        public void buttonsUpdateRequested();

        public void nextStepRequested();
    }
}

