/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public final class RunOnceUtil {
    public static boolean runOnceForProject(@NotNull Project project, @NotNull String id, @NotNull Runnable task) {
        return RunOnceUtil._runOnce(PropertiesComponent.getInstance(project), id, task);
    }

    public static boolean runOnceForApp(@NotNull String id, @NotNull Runnable task) {
        return RunOnceUtil._runOnce(PropertiesComponent.getInstance(), id, task);
    }

    private static boolean _runOnce(@NotNull PropertiesComponent storage, @NotNull String id, @NotNull Runnable activity) {
        String key = RunOnceUtil.createKey(id);
        if (storage.isTrueValue(key)) {
            return false;
        }
        activity.run();
        storage.setValue(key, true);
        return true;
    }

    private static String createKey(@NotNull String id) {
        return "RunOnceActivity." + id;
    }
}

