/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RootType {
    public static final ExtensionPointName<RootType> ROOT_EP = ExtensionPointName.create((String)"com.intellij.scratch.rootType");
    private final String myId;
    private final String myDisplayName;

    @NotNull
    public static List<RootType> getAllRootTypes() {
        return ROOT_EP.getExtensionList();
    }

    @NotNull
    public static RootType findById(@NotNull String id) {
        for (RootType type : RootType.getAllRootTypes()) {
            if (!id.equals(type.getId())) continue;
            return type;
        }
        throw new AssertionError((Object)id);
    }

    @NotNull
    public static <T extends RootType> T findByClass(@NotNull Class<T> aClass) {
        return (T)((RootType)ROOT_EP.findExtensionOrFail(aClass));
    }

    @Nullable
    public static RootType forFile(@Nullable VirtualFile file) {
        return ScratchFileService.findRootType(file);
    }

    protected RootType(@NotNull String id, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String displayName) {
        this.myId = id;
        this.myDisplayName = displayName;
    }

    @NotNull
    public final String getId() {
        return this.myId;
    }

    @Nullable
    @Nls(capitalization=Nls.Capitalization.Title)
    public final String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isHidden() {
        return StringUtil.isEmpty((String)this.myDisplayName);
    }

    public boolean containsFile(@Nullable VirtualFile file) {
        return ScratchFileService.findRootType(file) == this;
    }

    @Nullable
    public Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        return null;
    }

    @Nullable
    public Icon substituteIcon(@NotNull Project project, @NotNull VirtualFile file) {
        if (file.isDirectory()) {
            return null;
        }
        Language language = this.substituteLanguage(project, file);
        FileType fileType = LanguageUtil.getLanguageFileType(language);
        if (fileType == null) {
            String extension = file.getExtension();
            fileType = extension == null ? null : FileTypeManager.getInstance().getFileTypeByFileName(file.getNameSequence());
        }
        return fileType != null && fileType != UnknownFileType.INSTANCE ? fileType.getIcon() : null;
    }

    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file) {
        return null;
    }

    public VirtualFile findFile(@Nullable Project project, @NotNull String pathName, ScratchFileService.Option option) throws IOException {
        return ScratchFileService.getInstance().findFile(this, pathName, option);
    }

    public void fileOpened(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
    }

    public void fileClosed(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
    }

    public boolean isIgnored(@NotNull Project project, @NotNull VirtualFile element) {
        return false;
    }

    public void registerTreeUpdater(@NotNull Project project, @NotNull Disposable disposable, @NotNull Runnable onUpdate) {
    }
}

