/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.Patches;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Desktop;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "defaultBrowserCommand", "", "", "getDefaultBrowserCommand", "()Ljava/util/List;", "generalSettings", "Lcom/intellij/ide/GeneralSettings;", "getGeneralSettings", "()Lcom/intellij/ide/GeneralSettings;", "isDesktopActionSupported", "", "action", "Ljava/awt/Desktop$Action;", "intellij.platform.ide"})
public final class BrowserLauncherApplessKt {
    private static final Logger LOG;

    private static final boolean isDesktopActionSupported(Desktop.Action action) {
        return !Patches.SUN_BUG_ID_6486393 && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(action);
    }

    private static final GeneralSettings getGeneralSettings() {
        GeneralSettings generalSettings = ApplicationManager.getApplication() != null ? GeneralSettings.getInstance() : null;
        if (generalSettings == null) {
            generalSettings = new GeneralSettings();
        }
        return generalSettings;
    }

    private static final List<String> getDefaultBrowserCommand() {
        return SystemInfo.isWindows ? CollectionsKt.listOf((Object[])new String[]{ExecUtil.getWindowsShellName(), "/c", "start", GeneralCommandLine.inescapableQuote((String)"")}) : (SystemInfo.isMac ? CollectionsKt.listOf((Object)ExecUtil.getOpenCommandPath()) : (SystemInfo.isUnix && SystemInfo.hasXdgOpen() ? CollectionsKt.listOf((Object)"xdg-open") : null));
    }

    static {
        boolean $i$f$logger = false;
        LOG = Logger.getInstance(BrowserLauncherAppless.class);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$isDesktopActionSupported(Desktop.Action action) {
        return BrowserLauncherApplessKt.isDesktopActionSupported(action);
    }

    public static final /* synthetic */ GeneralSettings access$getGeneralSettings$p() {
        return BrowserLauncherApplessKt.getGeneralSettings();
    }

    public static final /* synthetic */ List access$getDefaultBrowserCommand$p() {
        return BrowserLauncherApplessKt.getDefaultBrowserCommand();
    }
}

