/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.ContributorSearchResult;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface WeightedSearchEverywhereContributor<I>
extends SearchEverywhereContributor<I> {
    public void fetchWeightedElements(@NotNull String var1, @NotNull ProgressIndicator var2, @NotNull Processor<? super FoundItemDescriptor<I>> var3);

    @Override
    default public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super I> consumer) {
        this.fetchWeightedElements(pattern, progressIndicator, descriptor -> consumer.process(descriptor.getItem()));
    }

    @NotNull
    default public ContributorSearchResult<? super FoundItemDescriptor<I>> searchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, int elementsLimit) {
        ContributorSearchResult.Builder builder = ContributorSearchResult.builder();
        this.fetchWeightedElements(pattern, progressIndicator, descriptor -> {
            if (elementsLimit < 0 || builder.itemsCount() < elementsLimit) {
                builder.addItem(descriptor);
                return true;
            }
            builder.setHasMore(true);
            return false;
        });
        return builder.build();
    }

    @NotNull
    default public List<? super FoundItemDescriptor<I>> searchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator) {
        ArrayList res = new ArrayList();
        this.fetchWeightedElements(pattern, progressIndicator, res::add);
        return res;
    }
}

