/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.ContributorSearchResult;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SearchEverywhereContributor<Item>
extends PossiblyDumbAware,
Disposable {
    public static final ExtensionPointName<SearchEverywhereContributorFactory<?>> EP_NAME = ExtensionPointName.create((String)"com.intellij.searchEverywhereContributor");

    @NotNull
    public String getSearchProviderId();

    @NotNull
    @Nls
    public String getGroupName();

    @NotNull
    default public String getFullGroupName() {
        return this.getGroupName();
    }

    public int getSortWeight();

    public boolean showInFindResults();

    default public boolean isShownInSeparateTab() {
        return false;
    }

    @Deprecated
    default public int getElementPriority(@NotNull Item element, @NotNull String searchPattern) {
        return 0;
    }

    @NotNull
    default public List<SearchEverywhereCommandInfo> getSupportedCommands() {
        return Collections.emptyList();
    }

    @Nullable
    default public String getAdvertisement() {
        return null;
    }

    @NotNull
    default public List<AnAction> getActions(@NotNull Runnable onChanged) {
        return Collections.emptyList();
    }

    public void fetchElements(@NotNull String var1, @NotNull ProgressIndicator var2, @NotNull Processor<? super Item> var3);

    @NotNull
    default public ContributorSearchResult<Item> search(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, int elementsLimit) {
        ContributorSearchResult.Builder builder = ContributorSearchResult.builder();
        this.fetchElements(pattern, progressIndicator, element -> {
            if (elementsLimit < 0 || builder.itemsCount() < elementsLimit) {
                builder.addItem(element);
                return true;
            }
            builder.setHasMore(true);
            return false;
        });
        return builder.build();
    }

    @NotNull
    default public List<Item> search(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator) {
        ArrayList res = new ArrayList();
        this.fetchElements(pattern, progressIndicator, o -> res.add(o));
        return res;
    }

    public boolean processSelectedItem(@NotNull Item var1, int var2, @NotNull String var3);

    @NotNull
    public ListCellRenderer<? super Item> getElementsRenderer();

    @Nullable
    public Object getDataForItem(@NotNull Item var1, @NotNull String var2);

    @NotNull
    default public String filterControlSymbols(@NotNull String pattern) {
        return pattern;
    }

    default public boolean isMultiSelectionSupported() {
        return false;
    }

    @Override
    default public boolean isDumbAware() {
        return true;
    }

    default public boolean isEmptyPatternSupported() {
        return false;
    }

    default public void dispose() {
    }
}

