/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class CreateInDirectoryActionBase
extends AnAction {
    protected CreateInDirectoryActionBase() {
    }

    protected CreateInDirectoryActionBase(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, Icon icon) {
        super(text, description, icon);
    }

    protected CreateInDirectoryActionBase(Supplier<String> dynamicText, Supplier<String> dynamicDescription, Icon icon) {
        super(dynamicText, dynamicDescription, icon);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        boolean enabled = this.isAvailable(e);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    @Override
    public boolean isDumbAware() {
        return false;
    }

    protected boolean isAvailable(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        return this.isAvailable(dataContext);
    }

    protected boolean isAvailable(DataContext dataContext) {
        Project project = CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        if (DumbService.getInstance(project).isDumb() && !this.isDumbAware()) {
            return false;
        }
        IdeView view = LangDataKeys.IDE_VIEW.getData(dataContext);
        return view != null && view.getDirectories().length != 0;
    }
}

