/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.datatransfer.StringSelection;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextCopyProvider
implements CopyProvider {
    @Nullable
    public abstract Collection<String> getTextLinesToCopy();

    @Override
    public void performCopy(@NotNull DataContext dataContext) {
        Collection<String> lines = this.getTextLinesToCopy();
        if (lines != null && !lines.isEmpty()) {
            String text = StringUtil.join(lines, (String)this.getLinesSeparator());
            CopyPasteManager.getInstance().setContents(new StringSelection(text));
        }
    }

    public String getLinesSeparator() {
        return "\n";
    }

    @Override
    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return this.getTextLinesToCopy() != null;
    }

    @Override
    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return true;
    }
}

